/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import android.content.Context;
import com.azure.android.communication.calling.AcceptTeamsCallOptions;
import com.azure.android.communication.calling.CommonIncomingCall;
import com.azure.android.communication.calling.ModeInCommunicationHelper;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.OutgoingAudioOptions;
import com.azure.android.communication.calling.PermissionUtility;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import com.azure.android.communication.calling.TeamsCall;
import com.azure.android.communication.calling.TeamsCallInfo;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java9.util.concurrent.CompletableFuture;
import java9.util.function.Supplier;

public final class TeamsIncomingCall
extends CommonIncomingCall {
    private static final ExecutorService executor = Executors.newCachedThreadPool();

    TeamsIncomingCall(long ahandle, boolean transfer) {
        super(ahandle, transfer);
    }

    @Override
    long getHandle() {
        return this.handle;
    }

    public TeamsCallInfo getCallInfo() {
        Out<Long> result_handle = new Out<Long>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_teams_incoming_call_get_call_info(this.handle, result_handle));
        TeamsCallInfo result_object = (Long)result_handle.value != 0L ? TeamsCallInfo.getInstance((Long)result_handle.value, true) : null;
        return result_object;
    }

    private CompletableFuture<TeamsCall> acceptWithContext(final Context context, final AcceptTeamsCallOptions options) {
        final long handle = this.handle;
        return CompletableFuture.supplyAsync((Supplier)new Supplier<TeamsCall>(){

            public TeamsCall get() {
                long options_converted = options != null ? options.getHandle() : 0L;
                Out<Long> result_handle = new Out<Long>();
                NativeLibraryHelpers.checkStatus(handle, NativeLibrary.sam_teams_incoming_call_accept_with_context(handle, context, options_converted, result_handle));
                TeamsCall result_object = TeamsCall.getInstance((Long)result_handle.value, true);
                return result_object;
            }
        }, (Executor)executor);
    }

    static TeamsIncomingCall getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.TeamsIncomingCall, TeamsIncomingCall.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_common_incoming_call_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.TeamsIncomingCall, TeamsIncomingCall.class, false);
    }

    public CompletableFuture<TeamsCall> accept(Context context, AcceptTeamsCallOptions acceptTeamsCallOptions) {
        PermissionUtility.throwIfNotAppropriatePermissions(context, acceptTeamsCallOptions != null ? acceptTeamsCallOptions.getOutgoingVideoOptions() : null, new OutgoingAudioOptions().setMuted(false));
        CompletableFuture<TeamsCall> compTeamsCall = this.acceptWithContext(context, acceptTeamsCallOptions);
        TeamsCall teamsCall = (TeamsCall)compTeamsCall.join();
        if (acceptTeamsCallOptions != null && acceptTeamsCallOptions.getOutgoingAudioOptions() != null && acceptTeamsCallOptions.getOutgoingAudioOptions().isCommunicationAudioModeEnabled()) {
            ModeInCommunicationHelper.setModeInCommunication(context, teamsCall);
        }
        return compTeamsCall;
    }

    public CompletableFuture<TeamsCall> accept(Context context) {
        return this.accept(context, new AcceptTeamsCallOptions());
    }
}

