/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.AudioOptions;
import com.azure.android.communication.calling.CallClient;
import com.azure.android.communication.calling.CallOptions;
import com.azure.android.communication.calling.IdentifierHelpers;
import com.azure.android.communication.calling.IncomingAudioOptions;
import com.azure.android.communication.calling.IncomingVideoOptions;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.OutgoingAudioOptions;
import com.azure.android.communication.calling.OutgoingVideoOptions;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import com.azure.android.communication.calling.Status;
import com.azure.android.communication.calling.VideoOptions;
import com.azure.android.communication.common.CommunicationIdentifier;
import com.azure.android.communication.common.PhoneNumberIdentifier;

public final class StartCallOptions
extends CallOptions {
    StartCallOptions(long ahandle, boolean transfer) {
        super(ahandle, transfer);
    }

    @Override
    long getHandle() {
        return this.handle;
    }

    static long Create() {
        Out<Long> result_handle = new Out<Long>();
        Status resultStatus = NativeLibrary.sam_start_call_options_create(result_handle);
        NativeLibraryHelpers.checkStatus((Long)result_handle.value, resultStatus);
        return (Long)result_handle.value;
    }

    public StartCallOptions() {
        super(StartCallOptions.Create(), true);
    }

    private String getAlternateId() {
        Out<String> result = new Out<String>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_start_call_options_get_alternate_id(this.handle, result));
        return (String)result.value;
    }

    private StartCallOptions setAlternateId(String value) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_start_call_options_set_alternate_id(this.handle, value));
        return this;
    }

    @Deprecated
    public VideoOptions getVideoOptions() {
        Out<Long> result_handle = new Out<Long>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_start_call_options_get_video_options(this.handle, result_handle));
        VideoOptions result_object = (Long)result_handle.value != 0L ? VideoOptions.getInstance((Long)result_handle.value, true) : null;
        return result_object;
    }

    @Deprecated
    public StartCallOptions setVideoOptions(VideoOptions value) {
        long value_converted = value != null ? value.getHandle() : 0L;
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_start_call_options_set_video_options(this.handle, value_converted));
        return this;
    }

    @Deprecated
    public AudioOptions getAudioOptions() {
        Out<Long> result_handle = new Out<Long>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_start_call_options_get_audio_options(this.handle, result_handle));
        AudioOptions result_object = (Long)result_handle.value != 0L ? AudioOptions.getInstance((Long)result_handle.value, true) : null;
        return result_object;
    }

    @Deprecated
    public StartCallOptions setAudioOptions(AudioOptions value) {
        long value_converted = value != null ? value.getHandle() : 0L;
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_start_call_options_set_audio_options(this.handle, value_converted));
        return this;
    }

    @Override
    public StartCallOptions setIncomingVideoOptions(IncomingVideoOptions value) {
        super.setIncomingVideoOptions(value);
        return this;
    }

    @Override
    public StartCallOptions setOutgoingVideoOptions(OutgoingVideoOptions value) {
        super.setOutgoingVideoOptions(value);
        return this;
    }

    @Override
    public StartCallOptions setIncomingAudioOptions(IncomingAudioOptions value) {
        super.setIncomingAudioOptions(value);
        return this;
    }

    @Override
    public StartCallOptions setOutgoingAudioOptions(OutgoingAudioOptions value) {
        super.setOutgoingAudioOptions(value);
        return this;
    }

    static StartCallOptions getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.StartCallOptions, StartCallOptions.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_call_options_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.StartCallOptions, StartCallOptions.class, false);
    }

    public StartCallOptions setAlternateCallerId(PhoneNumberIdentifier alternatePhoneNumber) {
        this.setAlternateId(IdentifierHelpers.toMRI((CommunicationIdentifier)alternatePhoneNumber));
        return this;
    }

    public PhoneNumberIdentifier getAlternateCallerId() {
        return (PhoneNumberIdentifier)IdentifierHelpers.from(this.getAlternateId());
    }

    static {
        CallClient.loadNativeLibraries();
    }
}

