/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import com.azure.android.communication.calling.SpotlightedParticipant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class SpotlightChangedEvent {
    long handle;

    SpotlightChangedEvent(long ahandle, boolean transfer) {
        this.handle = ahandle;
        if (!transfer) {
            NativeLibrary.sam_spotlight_changed_event_args_addref(ahandle);
        }
        ProjectedObjectCache.add(this, this.handle);
    }

    long getHandle() {
        return this.handle;
    }

    protected void finalize() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_spotlight_changed_event_args_release(this.handle));
        this.handle = 0L;
    }

    public List<SpotlightedParticipant> getAdded() {
        Out<long[]> result = new Out<long[]>();
        Out<Integer> result_length = new Out<Integer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_spotlight_changed_event_args_get_added(this.handle, result, result_length));
        ArrayList<SpotlightedParticipant> resultList = new ArrayList<SpotlightedParticipant>();
        long[] resultArray = (long[])result.value;
        for (int i = 0; i < resultArray.length; ++i) {
            resultList.add(SpotlightedParticipant.getInstance(resultArray[i], true));
        }
        List<SpotlightedParticipant> resultImmutable = Collections.unmodifiableList(resultList);
        return resultImmutable;
    }

    public List<SpotlightedParticipant> getRemoved() {
        Out<long[]> result = new Out<long[]>();
        Out<Integer> result_length = new Out<Integer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_spotlight_changed_event_args_get_removed(this.handle, result, result_length));
        ArrayList<SpotlightedParticipant> resultList = new ArrayList<SpotlightedParticipant>();
        long[] resultArray = (long[])result.value;
        for (int i = 0; i < resultArray.length; ++i) {
            resultList.add(SpotlightedParticipant.getInstance(resultArray[i], true));
        }
        List<SpotlightedParticipant> resultImmutable = Collections.unmodifiableList(resultList);
        return resultImmutable;
    }

    static SpotlightChangedEvent getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.SpotlightChangedEvent, SpotlightChangedEvent.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_spotlight_changed_event_args_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.SpotlightChangedEvent, SpotlightChangedEvent.class, false);
    }
}

