/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.CallFeature;
import com.azure.android.communication.calling.IdentifierHelpers;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import com.azure.android.communication.calling.ProjectedObjectEventHandlerCache;
import com.azure.android.communication.calling.SpotlightChangedEvent;
import com.azure.android.communication.calling.SpotlightChangedListener;
import com.azure.android.communication.calling.SpotlightedParticipant;
import com.azure.android.communication.common.CommunicationIdentifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java9.util.concurrent.CompletableFuture;

public final class SpotlightCallFeature
extends CallFeature {
    private static final ExecutorService executor = Executors.newCachedThreadPool();
    private List<SpotlightChangedListener> OnSpotlightChangedListeners = new CopyOnWriteArrayList<SpotlightChangedListener>();

    SpotlightCallFeature(long ahandle, boolean transfer) {
        super(ahandle, transfer);
    }

    SpotlightCallFeature(long ahandle, boolean transfer, boolean restoreEventHandlers) {
        this(ahandle, transfer);
        if (restoreEventHandlers) {
            this.restoreEventHandlers();
        }
    }

    @Override
    long getHandle() {
        return this.handle;
    }

    public int getMaxSpotlightedParticipants() {
        Out<Integer> result = new Out<Integer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_spotlight_call_feature_get_max_spotlighted_participants(this.handle, result));
        return (Integer)result.value;
    }

    public List<SpotlightedParticipant> getSpotlightedParticipants() {
        Out<long[]> result = new Out<long[]>();
        Out<Integer> result_length = new Out<Integer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_spotlight_call_feature_get_spotlighted_participants(this.handle, result, result_length));
        ArrayList<SpotlightedParticipant> resultList = new ArrayList<SpotlightedParticipant>();
        long[] resultArray = (long[])result.value;
        for (int i = 0; i < resultArray.length; ++i) {
            resultList.add(SpotlightedParticipant.getInstance(resultArray[i], true));
        }
        List<SpotlightedParticipant> resultImmutable = Collections.unmodifiableList(resultList);
        return resultImmutable;
    }

    private static void OnSpotlightChangedStaticHandler(long cookie, long args) {
        SpotlightCallFeature instance = SpotlightCallFeature.getInstance(cookie);
        if (instance != null) {
            SpotlightChangedEvent args_converted = args != 0L ? SpotlightChangedEvent.getInstance(args, false) : null;
            for (SpotlightChangedListener listener : instance.OnSpotlightChangedListeners) {
                listener.onSpotlightChanged(args_converted);
            }
        }
    }

    public void addOnSpotlightChangedListener(SpotlightChangedListener listener) {
        this.OnSpotlightChangedListeners.add(listener);
        ProjectedObjectEventHandlerCache.addEventHandler(this, this.getHandle(), "OnSpotlightChanged", listener);
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_spotlight_call_feature_set_on_spotlight_changed(this.handle, this.getHandle(), this));
    }

    public void removeOnSpotlightChangedListener(SpotlightChangedListener listener) {
        this.OnSpotlightChangedListeners.remove(listener);
        if (ProjectedObjectEventHandlerCache.removeEventHandler(this, this.getHandle(), "OnSpotlightChanged", listener)) {
            NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_spotlight_call_feature_set_on_spotlight_changed(this.handle, 0L, null));
        }
    }

    private CompletableFuture<Void> spotlightInternal(final String[] participants) {
        final long handle = this.handle;
        return CompletableFuture.runAsync((Runnable)new Runnable(){

            @Override
            public void run() {
                NativeLibraryHelpers.checkStatus(handle, NativeLibrary.sam_spotlight_call_feature_spotlight_internal(handle, participants, participants.length));
            }
        }, (Executor)executor);
    }

    private CompletableFuture<Void> cancelSpotlightInternal(final String[] participants) {
        final long handle = this.handle;
        return CompletableFuture.runAsync((Runnable)new Runnable(){

            @Override
            public void run() {
                NativeLibraryHelpers.checkStatus(handle, NativeLibrary.sam_spotlight_call_feature_cancel_spotlight_internal(handle, participants, participants.length));
            }
        }, (Executor)executor);
    }

    public CompletableFuture<Void> cancelAllSpotlights() {
        final long handle = this.handle;
        return CompletableFuture.runAsync((Runnable)new Runnable(){

            @Override
            public void run() {
                NativeLibraryHelpers.checkStatus(handle, NativeLibrary.sam_spotlight_call_feature_cancel_all_spotlights(handle));
            }
        }, (Executor)executor);
    }

    static SpotlightCallFeature getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.SpotlightCallFeature, SpotlightCallFeature.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_call_feature_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.SpotlightCallFeature, SpotlightCallFeature.class, false);
    }

    private static SpotlightCallFeature getInstance(long cookie) {
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.SpotlightCallFeature, SpotlightCallFeature.class, false);
    }

    void restoreEventHandlers() {
        for (Object eventListener : ProjectedObjectEventHandlerCache.getEventHandlers(this, this.getHandle(), "OnSpotlightChanged")) {
            this.addOnSpotlightChangedListener((SpotlightChangedListener)eventListener);
        }
    }

    public CompletableFuture<Void> spotlight(Iterable<CommunicationIdentifier> identifiers) {
        ArrayList<String> mris = new ArrayList<String>();
        for (CommunicationIdentifier identifier : identifiers) {
            mris.add(IdentifierHelpers.toMRI(identifier));
        }
        String[] mriArray = new String[mris.size()];
        return this.spotlightInternal(mris.toArray(mriArray));
    }

    public CompletableFuture<Void> spotlight(CommunicationIdentifier ... identifiers) {
        ArrayList<String> mris = new ArrayList<String>();
        for (CommunicationIdentifier identifier : identifiers) {
            mris.add(IdentifierHelpers.toMRI(identifier));
        }
        String[] mriArray = new String[mris.size()];
        return this.spotlightInternal(mris.toArray(mriArray));
    }

    public CompletableFuture<Void> cancelSpotlights(Iterable<CommunicationIdentifier> identifiers) {
        ArrayList<String> mris = new ArrayList<String>();
        for (CommunicationIdentifier identifier : identifiers) {
            mris.add(IdentifierHelpers.toMRI(identifier));
        }
        String[] mriArray = new String[mris.size()];
        return this.cancelSpotlightInternal(mris.toArray(mriArray));
    }

    public CompletableFuture<Void> cancelSpotlights(CommunicationIdentifier ... identifiers) {
        ArrayList<String> mris = new ArrayList<String>();
        for (CommunicationIdentifier identifier : identifiers) {
            mris.add(IdentifierHelpers.toMRI(identifier));
        }
        String[] mriArray = new String[mris.size()];
        return this.cancelSpotlightInternal(mris.toArray(mriArray));
    }
}

