/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import android.content.Context;
import com.azure.android.communication.calling.CallingCommunicationErrors;
import com.azure.android.communication.calling.CallingCommunicationException;
import com.azure.android.communication.calling.CreateViewOptions;
import com.azure.android.communication.calling.IVideoStreamRenderer;
import com.azure.android.communication.calling.Log;
import com.azure.android.communication.calling.RemoteIncomingVideoStreamView;
import com.azure.android.communication.calling.RemoteVideoStream;
import com.azure.android.communication.calling.RendererListener;
import com.azure.android.communication.calling.StreamSize;
import com.azure.android.communication.calling.VideoStreamState;
import com.azure.android.communication.calling.VideoStreamStateChangedEvent;
import com.azure.android.communication.calling.VideoStreamView;
import com.skype.android.video.render.BindingRenderer;
import com.skype.android.video.render.GLESBindingRenderer;
import java.io.Closeable;
import java.io.IOException;

class RemoteIncomingVideoStreamRenderer
implements IVideoStreamRenderer,
BindingRenderer.Callback,
Closeable {
    private static final String TAG = "RemoteIncomingVideoStreamRenderer";
    private final Context context;
    private final RemoteVideoStream remoteVideoStream;
    private GLESBindingRenderer renderer;
    private RemoteIncomingVideoStreamView videoStreamView;
    private RendererListener callback;

    RemoteIncomingVideoStreamRenderer(Context context, RemoteVideoStream remoteVideoStream) {
        this.context = context;
        this.remoteVideoStream = remoteVideoStream;
        this.remoteVideoStream.addOnStateChangedListener(this::OnVideoStreamStateChanged);
    }

    @Override
    public VideoStreamView StartPreview(CreateViewOptions options) {
        if (this.videoStreamView != null) {
            throw new CallingCommunicationException(CallingCommunicationErrors.MULTIPLE_VIEWS_NOT_SUPPORTED);
        }
        Log.debug1(TAG, "StartPreview videoId: %d", this.remoteVideoStream.getId());
        this.renderer = new GLESBindingRenderer((BindingRenderer.Callback)this);
        this.videoStreamView = new RemoteIncomingVideoStreamView(this.context, this.remoteVideoStream.getId(), options.getScalingMode());
        this.renderer.registerView((Object)this.videoStreamView.GetTextureView());
        this.remoteVideoStream.startPreviewNative(this.renderer.getNativeBindingEvent(), this.renderer.getNativeBindingType());
        Log.debug1(TAG, "Linking videoId: %d with viewId: %d", this.remoteVideoStream.getId(), System.identityHashCode(this.videoStreamView));
        return this.videoStreamView;
    }

    @Override
    public void StopPreview() {
        if (this.renderer != null) {
            Log.debug1(TAG, "StopPreview videoId: %d", this.remoteVideoStream.getId());
            this.renderer.unregisterView((Object)this.videoStreamView.GetTextureView());
            this.renderer = null;
            this.CleanVideoStreamView();
            this.remoteVideoStream.stopPreviewNative();
        }
    }

    private void OnVideoStreamStateChanged(VideoStreamStateChangedEvent args) {
        if (args.getStream().getState() == VideoStreamState.STOPPING) {
            this.StopPreview();
        }
    }

    public void onBindingCreated(long videoBindingHandle) {
        Log.debug1(TAG, "onBindingCreated videoId: %d", this.remoteVideoStream.getId());
        this.remoteVideoStream.onBindingCreated(videoBindingHandle);
    }

    public void onBindingReleased() {
        Log.debug1(TAG, "onBindingReleased videoId: %d", this.remoteVideoStream.getId());
        this.remoteVideoStream.onBindingReleased();
    }

    public void onBindingFailed() {
        Log.debug1(TAG, "onBindingFailed videoId: %d", this.remoteVideoStream.getId());
        this.remoteVideoStream.onBindingFailed();
        if (this.callback != null) {
            this.callback.onRendererFailedToStart();
        }
    }

    public void onSizeChanged(int w, int h) {
        Log.debug1(TAG, "onSizeChanged videoId: %d w: %d x h: %d", this.remoteVideoStream.getId(), w, h);
        this.videoStreamView.UpdateVideoFrameSize(w, h);
    }

    public void onRoiChanged(float v, float v1, float v2, float v3) {
        Log.debug1(TAG, "onRoiChanged videoId: %d", this.remoteVideoStream.getId());
    }

    public void onFirstFrameRendered() {
        Log.debug1(TAG, "onFirstFrameRendered videoId: %d", this.remoteVideoStream.getId());
        if (this.callback != null) {
            this.callback.onFirstFrameRendered();
        }
    }

    @Override
    public void SetRendererListener(RendererListener rendererListener) {
        this.callback = rendererListener;
    }

    @Override
    public StreamSize GetVideoFrameSize() {
        return this.videoStreamView.GetVideoFrameSize();
    }

    private void CleanVideoStreamView() {
        try {
            if (this.videoStreamView != null) {
                this.videoStreamView.close();
                this.videoStreamView = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void CleanRenderer() {
        if (this.renderer != null) {
            if (this.videoStreamView != null) {
                this.renderer.unregisterView((Object)this.videoStreamView);
            }
            this.renderer.dispose();
            this.renderer = null;
        }
    }

    @Override
    public void close() throws IOException {
        this.CleanRenderer();
        this.CleanVideoStreamView();
    }
}

