/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import com.azure.android.communication.calling.RawVideoFrame;
import com.azure.android.communication.calling.Status;
import com.azure.android.communication.calling.VideoStreamFormat;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public final class RawVideoFrameBuffer
extends RawVideoFrame {
    RawVideoFrameBuffer(long ahandle, boolean transfer) {
        super(ahandle, transfer);
    }

    @Override
    long getHandle() {
        return this.handle;
    }

    static long Create() {
        Out<Long> result_handle = new Out<Long>();
        Status resultStatus = NativeLibrary.sam_raw_video_frame_buffer_create(result_handle);
        NativeLibraryHelpers.checkStatus((Long)result_handle.value, resultStatus);
        return (Long)result_handle.value;
    }

    public RawVideoFrameBuffer() {
        super(RawVideoFrameBuffer.Create(), true);
    }

    private Object getBuffersAndroid() {
        Out<Object> result = new Out<Object>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_raw_video_frame_buffer_get_buffers_android(this.handle, result));
        return result.value;
    }

    private RawVideoFrameBuffer setBuffersAndroid(Object value) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_raw_video_frame_buffer_set_buffers_android(this.handle, value));
        return this;
    }

    @Override
    public RawVideoFrameBuffer setStreamFormat(VideoStreamFormat value) {
        super.setStreamFormat(value);
        return this;
    }

    @Override
    public RawVideoFrameBuffer setTimestampInTicks(long value) {
        super.setTimestampInTicks(value);
        return this;
    }

    static RawVideoFrameBuffer getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.RawVideoFrameBuffer, RawVideoFrameBuffer.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_raw_video_frame_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.RawVideoFrameBuffer, RawVideoFrameBuffer.class, false);
    }

    public List<ByteBuffer> getBuffers() {
        Out<Object> result_handle = new Out<Object>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_raw_video_frame_buffer_get_buffers_android(this.handle, result_handle));
        ByteBuffer[] byteBufferArray = (ByteBuffer[])result_handle.value;
        ArrayList<ByteBuffer> byteBufferList = new ArrayList<ByteBuffer>();
        for (int i = 0; i < byteBufferArray.length; ++i) {
            byteBufferList.add(byteBufferArray[i]);
        }
        return byteBufferList;
    }

    public RawVideoFrameBuffer setBuffers(List<ByteBuffer> byteBufferList) {
        ByteBuffer[] byteBufferArray = new ByteBuffer[byteBufferList.size()];
        for (int i = 0; i < byteBufferList.size(); ++i) {
            byteBufferArray[i] = byteBufferList.get(i);
        }
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_raw_video_frame_buffer_set_buffers_android(this.handle, byteBufferArray));
        return this;
    }
}

