/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.RawVideoFrameType;
import com.azure.android.communication.calling.VideoStreamFormat;

public abstract class RawVideoFrame
implements AutoCloseable {
    long handle;

    RawVideoFrame(long ahandle, boolean transfer) {
        this.handle = ahandle;
        if (!transfer) {
            NativeLibrary.sam_raw_video_frame_addref(ahandle);
        }
        ProjectedObjectCache.add(this, this.handle);
    }

    long getHandle() {
        return this.handle;
    }

    protected void finalize() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_raw_video_frame_release(this.handle));
        this.handle = 0L;
    }

    public RawVideoFrameType getType() {
        Out<RawVideoFrameType> result = new Out<RawVideoFrameType>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_raw_video_frame_get_type(this.handle, result));
        return (RawVideoFrameType)((Object)result.value);
    }

    public VideoStreamFormat getStreamFormat() {
        Out<Long> result_handle = new Out<Long>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_raw_video_frame_get_stream_format(this.handle, result_handle));
        VideoStreamFormat result_object = (Long)result_handle.value != 0L ? VideoStreamFormat.getInstance((Long)result_handle.value, true) : null;
        return result_object;
    }

    public RawVideoFrame setStreamFormat(VideoStreamFormat value) {
        long value_converted = value != null ? value.getHandle() : 0L;
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_raw_video_frame_set_stream_format(this.handle, value_converted));
        return this;
    }

    public long getTimestampInTicks() {
        Out<Long> result = new Out<Long>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_raw_video_frame_get_timestamp_in_ticks(this.handle, result));
        return (Long)result.value;
    }

    public RawVideoFrame setTimestampInTicks(long value) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_raw_video_frame_set_timestamp_in_ticks(this.handle, value));
        return this;
    }

    @Override
    public void close() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_raw_video_frame_dispose(this.handle));
    }
}

