/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.OutgoingVideoStream;
import com.azure.android.communication.calling.RawVideoFrame;
import com.azure.android.communication.calling.VideoStreamFormat;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java9.util.concurrent.CompletableFuture;

public abstract class RawOutgoingVideoStream
extends OutgoingVideoStream {
    private static final ExecutorService executor = Executors.newCachedThreadPool();

    RawOutgoingVideoStream(long ahandle, boolean transfer) {
        super(ahandle, transfer);
    }

    @Override
    long getHandle() {
        return this.handle;
    }

    public VideoStreamFormat getFormat() {
        Out<Long> result_handle = new Out<Long>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_raw_outgoing_video_stream_get_format(this.handle, result_handle));
        VideoStreamFormat result_object = (Long)result_handle.value != 0L ? VideoStreamFormat.getInstance((Long)result_handle.value, true) : null;
        return result_object;
    }

    public long getTimestampInTicks() {
        Out<Long> result = new Out<Long>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_raw_outgoing_video_stream_get_timestamp_in_ticks(this.handle, result));
        return (Long)result.value;
    }

    public CompletableFuture<Void> sendRawVideoFrame(final RawVideoFrame rawVideoFrame) {
        final long handle = this.handle;
        return CompletableFuture.runAsync((Runnable)new Runnable(){

            @Override
            public void run() {
                long rawVideoFrame_converted = rawVideoFrame != null ? rawVideoFrame.getHandle() : 0L;
                NativeLibraryHelpers.checkStatus(handle, NativeLibrary.sam_raw_outgoing_video_stream_send_raw_video_frame(handle, rawVideoFrame_converted));
            }
        }, (Executor)executor);
    }
}

