/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.IncomingVideoStream;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import com.azure.android.communication.calling.ProjectedObjectEventHandlerCache;
import com.azure.android.communication.calling.RawVideoFrameReceivedEvent;
import com.azure.android.communication.calling.RawVideoFrameReceivedListener;
import com.azure.android.communication.calling.VideoStreamStateChangedEvent;
import com.azure.android.communication.calling.VideoStreamStateChangedListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public final class RawIncomingVideoStream
extends IncomingVideoStream {
    private List<RawVideoFrameReceivedListener> OnRawVideoFrameReceivedListeners = new CopyOnWriteArrayList<RawVideoFrameReceivedListener>();
    private List<VideoStreamStateChangedListener> OnStateChangedListeners = new CopyOnWriteArrayList<VideoStreamStateChangedListener>();

    RawIncomingVideoStream(long ahandle, boolean transfer) {
        super(ahandle, transfer);
    }

    RawIncomingVideoStream(long ahandle, boolean transfer, boolean restoreEventHandlers) {
        this(ahandle, transfer);
        if (restoreEventHandlers) {
            this.restoreEventHandlers();
        }
    }

    @Override
    long getHandle() {
        return this.handle;
    }

    private static void OnRawVideoFrameReceivedStaticHandler(long cookie, long args) {
        RawIncomingVideoStream instance = RawIncomingVideoStream.getInstance(cookie);
        if (instance != null) {
            RawVideoFrameReceivedEvent args_converted = args != 0L ? RawVideoFrameReceivedEvent.getInstance(args, false) : null;
            for (RawVideoFrameReceivedListener listener : instance.OnRawVideoFrameReceivedListeners) {
                listener.onRawVideoFrameReceived(args_converted);
            }
        }
    }

    public void addOnRawVideoFrameReceivedListener(RawVideoFrameReceivedListener listener) {
        this.OnRawVideoFrameReceivedListeners.add(listener);
        ProjectedObjectEventHandlerCache.addEventHandler(this, this.getHandle(), "OnRawVideoFrameReceived", listener);
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_raw_incoming_video_stream_set_on_raw_video_frame_received(this.handle, this.getHandle(), this));
    }

    public void removeOnRawVideoFrameReceivedListener(RawVideoFrameReceivedListener listener) {
        this.OnRawVideoFrameReceivedListeners.remove(listener);
        if (ProjectedObjectEventHandlerCache.removeEventHandler(this, this.getHandle(), "OnRawVideoFrameReceived", listener)) {
            NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_raw_incoming_video_stream_set_on_raw_video_frame_received(this.handle, 0L, null));
        }
    }

    private static void OnStateChangedStaticHandler(long cookie, long args) {
        RawIncomingVideoStream instance = RawIncomingVideoStream.getInstance(cookie);
        if (instance != null) {
            VideoStreamStateChangedEvent args_converted = args != 0L ? VideoStreamStateChangedEvent.getInstance(args, false) : null;
            for (VideoStreamStateChangedListener listener : instance.OnStateChangedListeners) {
                listener.onVideoStreamStateChanged(args_converted);
            }
        }
    }

    public void addOnStateChangedListener(VideoStreamStateChangedListener listener) {
        this.OnStateChangedListeners.add(listener);
        ProjectedObjectEventHandlerCache.addEventHandler(this, this.getHandle(), "OnStateChanged", listener);
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_raw_incoming_video_stream_set_on_state_changed(this.handle, this.getHandle(), this));
    }

    public void removeOnStateChangedListener(VideoStreamStateChangedListener listener) {
        this.OnStateChangedListeners.remove(listener);
        if (ProjectedObjectEventHandlerCache.removeEventHandler(this, this.getHandle(), "OnStateChanged", listener)) {
            NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_raw_incoming_video_stream_set_on_state_changed(this.handle, 0L, null));
        }
    }

    public void start() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_raw_incoming_video_stream_start(this.handle));
    }

    public void stop() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_raw_incoming_video_stream_stop(this.handle));
    }

    static RawIncomingVideoStream getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.RawIncomingVideoStream, RawIncomingVideoStream.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_call_video_stream_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.RawIncomingVideoStream, RawIncomingVideoStream.class, false);
    }

    private static RawIncomingVideoStream getInstance(long cookie) {
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.RawIncomingVideoStream, RawIncomingVideoStream.class, false);
    }

    void restoreEventHandlers() {
        for (Object eventListener : ProjectedObjectEventHandlerCache.getEventHandlers(this, this.getHandle(), "OnRawVideoFrameReceived")) {
            this.addOnRawVideoFrameReceivedListener((RawVideoFrameReceivedListener)eventListener);
        }
        for (Object eventListener : ProjectedObjectEventHandlerCache.getEventHandlers(this, this.getHandle(), "OnStateChanged")) {
            this.addOnStateChangedListener((VideoStreamStateChangedListener)eventListener);
        }
    }
}

