/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.InternalObjectHelpers;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;

public final class OutgoingVideoStatistics {
    long handle;

    OutgoingVideoStatistics(long ahandle, boolean transfer) {
        this.handle = ahandle;
        if (!transfer) {
            NativeLibrary.sam_outgoing_video_statistics_addref(ahandle);
        }
        ProjectedObjectCache.add(this, this.handle);
    }

    long getHandle() {
        return this.handle;
    }

    protected void finalize() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_outgoing_video_statistics_release(this.handle));
        this.handle = 0L;
    }

    public String getCodecName() {
        Out<String> result = new Out<String>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_outgoing_video_statistics_get_codec_name(this.handle, result));
        return (String)result.value;
    }

    private int getBitrateInBpsInternal() {
        Out<Integer> result = new Out<Integer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_outgoing_video_statistics_get_bitrate_in_bps_internal(this.handle, result));
        return (Integer)result.value;
    }

    private int getPacketCountInternal() {
        Out<Integer> result = new Out<Integer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_outgoing_video_statistics_get_packet_count_internal(this.handle, result));
        return (Integer)result.value;
    }

    private int getStreamIdInternal() {
        Out<Integer> result = new Out<Integer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_outgoing_video_statistics_get_stream_id_internal(this.handle, result));
        return (Integer)result.value;
    }

    private float getFrameRateInternal() {
        Out<Float> result = new Out<Float>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_outgoing_video_statistics_get_frame_rate_internal(this.handle, result));
        return ((Float)result.value).floatValue();
    }

    private int getFrameWidthInternal() {
        Out<Integer> result = new Out<Integer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_outgoing_video_statistics_get_frame_width_internal(this.handle, result));
        return (Integer)result.value;
    }

    private int getFrameHeightInternal() {
        Out<Integer> result = new Out<Integer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_outgoing_video_statistics_get_frame_height_internal(this.handle, result));
        return (Integer)result.value;
    }

    static OutgoingVideoStatistics getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.OutgoingVideoStatistics, OutgoingVideoStatistics.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_outgoing_video_statistics_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.OutgoingVideoStatistics, OutgoingVideoStatistics.class, false);
    }

    public Integer getBitrateInBps() {
        return InternalObjectHelpers.extractIntegerObject(() -> this.getBitrateInBpsInternal());
    }

    public Integer getPacketCount() {
        return InternalObjectHelpers.extractIntegerObject(() -> this.getPacketCountInternal());
    }

    public Integer getStreamId() {
        return InternalObjectHelpers.extractIntegerObject(() -> this.getStreamIdInternal());
    }

    public Float getFrameRate() {
        return InternalObjectHelpers.extractFloatObject(() -> this.getFrameRateInternal());
    }

    public Integer getFrameWidth() {
        return InternalObjectHelpers.extractIntegerObject(() -> this.getFrameWidthInternal());
    }

    public Integer getFrameHeight() {
        return InternalObjectHelpers.extractIntegerObject(() -> this.getFrameHeightInternal());
    }
}

