/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.OutgoingAudioStatistics;
import com.azure.android.communication.calling.OutgoingDataChannelStatistics;
import com.azure.android.communication.calling.OutgoingScreenShareStatistics;
import com.azure.android.communication.calling.OutgoingVideoStatistics;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class OutgoingMediaStatistics {
    long handle;

    OutgoingMediaStatistics(long ahandle, boolean transfer) {
        this.handle = ahandle;
        if (!transfer) {
            NativeLibrary.sam_outgoing_media_statistics_addref(ahandle);
        }
        ProjectedObjectCache.add(this, this.handle);
    }

    long getHandle() {
        return this.handle;
    }

    protected void finalize() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_outgoing_media_statistics_release(this.handle));
        this.handle = 0L;
    }

    private List<OutgoingAudioStatistics> getAudioInternal() {
        Out<long[]> result = new Out<long[]>();
        Out<Integer> result_length = new Out<Integer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_outgoing_media_statistics_get_audio_internal(this.handle, result, result_length));
        ArrayList<OutgoingAudioStatistics> resultList = new ArrayList<OutgoingAudioStatistics>();
        long[] resultArray = (long[])result.value;
        for (int i = 0; i < resultArray.length; ++i) {
            resultList.add(OutgoingAudioStatistics.getInstance(resultArray[i], true));
        }
        List<OutgoingAudioStatistics> resultImmutable = Collections.unmodifiableList(resultList);
        return resultImmutable;
    }

    private List<OutgoingVideoStatistics> getVideoInternal() {
        Out<long[]> result = new Out<long[]>();
        Out<Integer> result_length = new Out<Integer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_outgoing_media_statistics_get_video_internal(this.handle, result, result_length));
        ArrayList<OutgoingVideoStatistics> resultList = new ArrayList<OutgoingVideoStatistics>();
        long[] resultArray = (long[])result.value;
        for (int i = 0; i < resultArray.length; ++i) {
            resultList.add(OutgoingVideoStatistics.getInstance(resultArray[i], true));
        }
        List<OutgoingVideoStatistics> resultImmutable = Collections.unmodifiableList(resultList);
        return resultImmutable;
    }

    private List<OutgoingScreenShareStatistics> getScreenShareInternal() {
        Out<long[]> result = new Out<long[]>();
        Out<Integer> result_length = new Out<Integer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_outgoing_media_statistics_get_screen_share_internal(this.handle, result, result_length));
        ArrayList<OutgoingScreenShareStatistics> resultList = new ArrayList<OutgoingScreenShareStatistics>();
        long[] resultArray = (long[])result.value;
        for (int i = 0; i < resultArray.length; ++i) {
            resultList.add(OutgoingScreenShareStatistics.getInstance(resultArray[i], true));
        }
        List<OutgoingScreenShareStatistics> resultImmutable = Collections.unmodifiableList(resultList);
        return resultImmutable;
    }

    private List<OutgoingDataChannelStatistics> getDataChannelInternal() {
        Out<long[]> result = new Out<long[]>();
        Out<Integer> result_length = new Out<Integer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_outgoing_media_statistics_get_data_channel_internal(this.handle, result, result_length));
        ArrayList<OutgoingDataChannelStatistics> resultList = new ArrayList<OutgoingDataChannelStatistics>();
        long[] resultArray = (long[])result.value;
        for (int i = 0; i < resultArray.length; ++i) {
            resultList.add(OutgoingDataChannelStatistics.getInstance(resultArray[i], true));
        }
        List<OutgoingDataChannelStatistics> resultImmutable = Collections.unmodifiableList(resultList);
        return resultImmutable;
    }

    static OutgoingMediaStatistics getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.OutgoingMediaStatistics, OutgoingMediaStatistics.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_outgoing_media_statistics_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.OutgoingMediaStatistics, OutgoingMediaStatistics.class, false);
    }

    public List<OutgoingAudioStatistics> getAudioStatistics() {
        return this.getAudioInternal();
    }

    public List<OutgoingVideoStatistics> getVideoStatistics() {
        return this.getVideoInternal();
    }

    public List<OutgoingScreenShareStatistics> getScreenShareStatistics() {
        return this.getScreenShareInternal();
    }

    public List<OutgoingDataChannelStatistics> getDataChannelStatistics() {
        return this.getDataChannelInternal();
    }
}

