/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.InternalObjectHelpers;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;

public final class OutgoingDataChannelStatistics {
    long handle;

    OutgoingDataChannelStatistics(long ahandle, boolean transfer) {
        this.handle = ahandle;
        if (!transfer) {
            NativeLibrary.sam_outgoing_data_channel_statistics_addref(ahandle);
        }
        ProjectedObjectCache.add(this, this.handle);
    }

    long getHandle() {
        return this.handle;
    }

    protected void finalize() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_outgoing_data_channel_statistics_release(this.handle));
        this.handle = 0L;
    }

    private int getPacketCountInternal() {
        Out<Integer> result = new Out<Integer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_outgoing_data_channel_statistics_get_packet_count_internal(this.handle, result));
        return (Integer)result.value;
    }

    static OutgoingDataChannelStatistics getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.OutgoingDataChannelStatistics, OutgoingDataChannelStatistics.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_outgoing_data_channel_statistics_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.OutgoingDataChannelStatistics, OutgoingDataChannelStatistics.class, false);
    }

    public Integer getPacketCount() {
        return InternalObjectHelpers.extractIntegerObject(() -> this.getPacketCountInternal());
    }
}

