/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.DiagnosticQuality;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.NetworkDiagnosticType;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import java.util.Date;

public final class NetworkDiagnosticValues {
    long handle;

    NetworkDiagnosticValues(long ahandle, boolean transfer) {
        this.handle = ahandle;
        if (!transfer) {
            NativeLibrary.sam_network_diagnostic_values_addref(ahandle);
        }
        ProjectedObjectCache.add(this, this.handle);
    }

    long getHandle() {
        return this.handle;
    }

    protected void finalize() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_network_diagnostic_values_release(this.handle));
        this.handle = 0L;
    }

    public Date getLastUpdatedAt() {
        Out<Long> result = new Out<Long>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_network_diagnostic_values_get_last_updated_at(this.handle, result));
        return (Long)result.value == 0L ? new Date(Long.MAX_VALUE) : new Date((Long)result.value);
    }

    private DiagnosticQuality getQualityValueInternal(NetworkDiagnosticType diagnostic) {
        Out<DiagnosticQuality> result = new Out<DiagnosticQuality>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_network_diagnostic_values_get_quality_value_internal(this.handle, diagnostic, result));
        return (DiagnosticQuality)((Object)result.value);
    }

    private boolean getBoolValueInternal(NetworkDiagnosticType diagnostic) {
        Out<Boolean> result = new Out<Boolean>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_network_diagnostic_values_get_bool_value_internal(this.handle, diagnostic, result));
        return (Boolean)result.value;
    }

    static NetworkDiagnosticValues getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.NetworkDiagnosticValues, NetworkDiagnosticValues.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_network_diagnostic_values_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.NetworkDiagnosticValues, NetworkDiagnosticValues.class, false);
    }

    private Boolean getBoolValueIfExists(NetworkDiagnosticType diagnostic) {
        try {
            return this.getBoolValueInternal(diagnostic);
        }
        catch (IllegalStateException e) {
            return null;
        }
    }

    public Boolean isNetworkUnavailable() {
        return this.getBoolValueIfExists(NetworkDiagnosticType.NETWORK_UNAVAILABLE);
    }

    public Boolean isNetworkRelaysUnreachable() {
        return this.getBoolValueIfExists(NetworkDiagnosticType.NETWORK_RELAYS_UNREACHABLE);
    }

    public DiagnosticQuality getNetworkReconnectionQuality() {
        return this.getQualityValueInternal(NetworkDiagnosticType.NETWORK_RECONNECT);
    }

    public DiagnosticQuality getNetworkReceiveQuality() {
        return this.getQualityValueInternal(NetworkDiagnosticType.NETWORK_RECEIVE_QUALITY);
    }

    public DiagnosticQuality getNetworkSendQuality() {
        return this.getQualityValueInternal(NetworkDiagnosticType.NETWORK_SEND_QUALITY);
    }
}

