/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.IncomingMediaStatistics;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.OutgoingMediaStatistics;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import java.util.Date;

public final class MediaStatisticsReport {
    long handle;

    MediaStatisticsReport(long ahandle, boolean transfer) {
        this.handle = ahandle;
        if (!transfer) {
            NativeLibrary.sam_media_statistics_report_addref(ahandle);
        }
        ProjectedObjectCache.add(this, this.handle);
    }

    long getHandle() {
        return this.handle;
    }

    protected void finalize() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_media_statistics_report_release(this.handle));
        this.handle = 0L;
    }

    public OutgoingMediaStatistics getOutgoingStatistics() {
        Out<Long> result_handle = new Out<Long>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_media_statistics_report_get_outgoing_statistics(this.handle, result_handle));
        OutgoingMediaStatistics result_object = (Long)result_handle.value != 0L ? OutgoingMediaStatistics.getInstance((Long)result_handle.value, true) : null;
        return result_object;
    }

    public IncomingMediaStatistics getIncomingStatistics() {
        Out<Long> result_handle = new Out<Long>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_media_statistics_report_get_incoming_statistics(this.handle, result_handle));
        IncomingMediaStatistics result_object = (Long)result_handle.value != 0L ? IncomingMediaStatistics.getInstance((Long)result_handle.value, true) : null;
        return result_object;
    }

    public Date getLastUpdatedAt() {
        Out<Long> result = new Out<Long>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_media_statistics_report_get_last_updated_at(this.handle, result));
        return (Long)result.value == 0L ? new Date(Long.MAX_VALUE) : new Date((Long)result.value);
    }

    static MediaStatisticsReport getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.MediaStatisticsReport, MediaStatisticsReport.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_media_statistics_report_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.MediaStatisticsReport, MediaStatisticsReport.class, false);
    }
}

