/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.CallFeature;
import com.azure.android.communication.calling.MediaStatisticsReportReceivedEvent;
import com.azure.android.communication.calling.MediaStatisticsReportReceivedListener;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import com.azure.android.communication.calling.ProjectedObjectEventHandlerCache;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public final class MediaStatisticsCallFeature
extends CallFeature {
    private List<MediaStatisticsReportReceivedListener> OnReportReceivedListeners = new CopyOnWriteArrayList<MediaStatisticsReportReceivedListener>();

    MediaStatisticsCallFeature(long ahandle, boolean transfer) {
        super(ahandle, transfer);
    }

    MediaStatisticsCallFeature(long ahandle, boolean transfer, boolean restoreEventHandlers) {
        this(ahandle, transfer);
        if (restoreEventHandlers) {
            this.restoreEventHandlers();
        }
    }

    @Override
    long getHandle() {
        return this.handle;
    }

    public int getReportIntervalInSeconds() {
        Out<Integer> result = new Out<Integer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_media_statistics_call_feature_get_report_interval_in_seconds(this.handle, result));
        return (Integer)result.value;
    }

    private static void OnReportReceivedStaticHandler(long cookie, long args) {
        MediaStatisticsCallFeature instance = MediaStatisticsCallFeature.getInstance(cookie);
        if (instance != null) {
            MediaStatisticsReportReceivedEvent args_converted = args != 0L ? MediaStatisticsReportReceivedEvent.getInstance(args, false) : null;
            for (MediaStatisticsReportReceivedListener listener : instance.OnReportReceivedListeners) {
                listener.onMediaStatisticsReportReceived(args_converted);
            }
        }
    }

    public void addOnReportReceivedListener(MediaStatisticsReportReceivedListener listener) {
        this.OnReportReceivedListeners.add(listener);
        ProjectedObjectEventHandlerCache.addEventHandler(this, this.getHandle(), "OnReportReceived", listener);
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_media_statistics_call_feature_set_on_report_received(this.handle, this.getHandle(), this));
    }

    public void removeOnReportReceivedListener(MediaStatisticsReportReceivedListener listener) {
        this.OnReportReceivedListeners.remove(listener);
        if (ProjectedObjectEventHandlerCache.removeEventHandler(this, this.getHandle(), "OnReportReceived", listener)) {
            NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_media_statistics_call_feature_set_on_report_received(this.handle, 0L, null));
        }
    }

    public void updateReportIntervalInSeconds(int reportIntervalInSeconds) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_media_statistics_call_feature_update_report_interval_in_seconds(this.handle, reportIntervalInSeconds));
    }

    static MediaStatisticsCallFeature getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.MediaStatisticsCallFeature, MediaStatisticsCallFeature.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_call_feature_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.MediaStatisticsCallFeature, MediaStatisticsCallFeature.class, false);
    }

    private static MediaStatisticsCallFeature getInstance(long cookie) {
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.MediaStatisticsCallFeature, MediaStatisticsCallFeature.class, false);
    }

    void restoreEventHandlers() {
        for (Object eventListener : ProjectedObjectEventHandlerCache.getEventHandlers(this, this.getHandle(), "OnReportReceived")) {
            this.addOnReportReceivedListener((MediaStatisticsReportReceivedListener)eventListener);
        }
    }
}

