/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.DiagnosticFlagChangedEvent;
import com.azure.android.communication.calling.DiagnosticFlagChangedListener;
import com.azure.android.communication.calling.MediaDiagnosticValues;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import com.azure.android.communication.calling.ProjectedObjectEventHandlerCache;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public final class MediaDiagnostics {
    long handle;
    private List<DiagnosticFlagChangedListener> OnIsSpeakerNotFunctioningChangedListeners = new CopyOnWriteArrayList<DiagnosticFlagChangedListener>();
    private List<DiagnosticFlagChangedListener> OnIsSpeakerBusyChangedListeners = new CopyOnWriteArrayList<DiagnosticFlagChangedListener>();
    private List<DiagnosticFlagChangedListener> OnIsSpeakerMutedChangedListeners = new CopyOnWriteArrayList<DiagnosticFlagChangedListener>();
    private List<DiagnosticFlagChangedListener> OnIsSpeakerVolumeZeroChangedListeners = new CopyOnWriteArrayList<DiagnosticFlagChangedListener>();
    private List<DiagnosticFlagChangedListener> OnIsNoSpeakerDevicesAvailableChangedListeners = new CopyOnWriteArrayList<DiagnosticFlagChangedListener>();
    private List<DiagnosticFlagChangedListener> OnIsSpeakingWhileMicrophoneIsMutedChangedListeners = new CopyOnWriteArrayList<DiagnosticFlagChangedListener>();
    private List<DiagnosticFlagChangedListener> OnIsNoMicrophoneDevicesAvailableChangedListeners = new CopyOnWriteArrayList<DiagnosticFlagChangedListener>();
    private List<DiagnosticFlagChangedListener> OnIsMicrophoneBusyChangedListeners = new CopyOnWriteArrayList<DiagnosticFlagChangedListener>();
    private List<DiagnosticFlagChangedListener> OnIsCameraFrozenChangedListeners = new CopyOnWriteArrayList<DiagnosticFlagChangedListener>();
    private List<DiagnosticFlagChangedListener> OnIsCameraStartFailedChangedListeners = new CopyOnWriteArrayList<DiagnosticFlagChangedListener>();
    private List<DiagnosticFlagChangedListener> OnIsCameraStartTimedOutChangedListeners = new CopyOnWriteArrayList<DiagnosticFlagChangedListener>();
    private List<DiagnosticFlagChangedListener> OnIsMicrophoneNotFunctioningChangedListeners = new CopyOnWriteArrayList<DiagnosticFlagChangedListener>();
    private List<DiagnosticFlagChangedListener> OnIsMicrophoneMutedUnexpectedlyChangedListeners = new CopyOnWriteArrayList<DiagnosticFlagChangedListener>();
    private List<DiagnosticFlagChangedListener> OnIsCameraPermissionDeniedChangedListeners = new CopyOnWriteArrayList<DiagnosticFlagChangedListener>();

    MediaDiagnostics(long ahandle, boolean transfer) {
        this.handle = ahandle;
        if (!transfer) {
            NativeLibrary.sam_media_diagnostics_addref(ahandle);
        }
        ProjectedObjectCache.add(this, this.handle);
    }

    MediaDiagnostics(long ahandle, boolean transfer, boolean restoreEventHandlers) {
        this(ahandle, transfer);
        if (restoreEventHandlers) {
            this.restoreEventHandlers();
        }
    }

    long getHandle() {
        return this.handle;
    }

    protected void finalize() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_media_diagnostics_release(this.handle));
        this.handle = 0L;
    }

    private MediaDiagnosticValues getLatestInternal() {
        Out<Long> result_handle = new Out<Long>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_media_diagnostics_get_latest_internal(this.handle, result_handle));
        MediaDiagnosticValues result_object = (Long)result_handle.value != 0L ? MediaDiagnosticValues.getInstance((Long)result_handle.value, true) : null;
        return result_object;
    }

    private static void OnIsSpeakerNotFunctioningChangedStaticHandler(long cookie, long args) {
        MediaDiagnostics instance = MediaDiagnostics.getInstance(cookie);
        if (instance != null) {
            DiagnosticFlagChangedEvent args_converted = args != 0L ? DiagnosticFlagChangedEvent.getInstance(args, false) : null;
            for (DiagnosticFlagChangedListener listener : instance.OnIsSpeakerNotFunctioningChangedListeners) {
                listener.onDiagnosticFlagChanged(args_converted);
            }
        }
    }

    public void addOnIsSpeakerNotFunctioningChangedListener(DiagnosticFlagChangedListener listener) {
        this.OnIsSpeakerNotFunctioningChangedListeners.add(listener);
        ProjectedObjectEventHandlerCache.addEventHandler(this, this.getHandle(), "OnIsSpeakerNotFunctioningChanged", listener);
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_media_diagnostics_set_on_is_speaker_not_functioning_changed(this.handle, this.getHandle(), this));
    }

    public void removeOnIsSpeakerNotFunctioningChangedListener(DiagnosticFlagChangedListener listener) {
        this.OnIsSpeakerNotFunctioningChangedListeners.remove(listener);
        if (ProjectedObjectEventHandlerCache.removeEventHandler(this, this.getHandle(), "OnIsSpeakerNotFunctioningChanged", listener)) {
            NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_media_diagnostics_set_on_is_speaker_not_functioning_changed(this.handle, 0L, null));
        }
    }

    private static void OnIsSpeakerBusyChangedStaticHandler(long cookie, long args) {
        MediaDiagnostics instance = MediaDiagnostics.getInstance(cookie);
        if (instance != null) {
            DiagnosticFlagChangedEvent args_converted = args != 0L ? DiagnosticFlagChangedEvent.getInstance(args, false) : null;
            for (DiagnosticFlagChangedListener listener : instance.OnIsSpeakerBusyChangedListeners) {
                listener.onDiagnosticFlagChanged(args_converted);
            }
        }
    }

    public void addOnIsSpeakerBusyChangedListener(DiagnosticFlagChangedListener listener) {
        this.OnIsSpeakerBusyChangedListeners.add(listener);
        ProjectedObjectEventHandlerCache.addEventHandler(this, this.getHandle(), "OnIsSpeakerBusyChanged", listener);
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_media_diagnostics_set_on_is_speaker_busy_changed(this.handle, this.getHandle(), this));
    }

    public void removeOnIsSpeakerBusyChangedListener(DiagnosticFlagChangedListener listener) {
        this.OnIsSpeakerBusyChangedListeners.remove(listener);
        if (ProjectedObjectEventHandlerCache.removeEventHandler(this, this.getHandle(), "OnIsSpeakerBusyChanged", listener)) {
            NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_media_diagnostics_set_on_is_speaker_busy_changed(this.handle, 0L, null));
        }
    }

    private static void OnIsSpeakerMutedChangedStaticHandler(long cookie, long args) {
        MediaDiagnostics instance = MediaDiagnostics.getInstance(cookie);
        if (instance != null) {
            DiagnosticFlagChangedEvent args_converted = args != 0L ? DiagnosticFlagChangedEvent.getInstance(args, false) : null;
            for (DiagnosticFlagChangedListener listener : instance.OnIsSpeakerMutedChangedListeners) {
                listener.onDiagnosticFlagChanged(args_converted);
            }
        }
    }

    public void addOnIsSpeakerMutedChangedListener(DiagnosticFlagChangedListener listener) {
        this.OnIsSpeakerMutedChangedListeners.add(listener);
        ProjectedObjectEventHandlerCache.addEventHandler(this, this.getHandle(), "OnIsSpeakerMutedChanged", listener);
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_media_diagnostics_set_on_is_speaker_muted_changed(this.handle, this.getHandle(), this));
    }

    public void removeOnIsSpeakerMutedChangedListener(DiagnosticFlagChangedListener listener) {
        this.OnIsSpeakerMutedChangedListeners.remove(listener);
        if (ProjectedObjectEventHandlerCache.removeEventHandler(this, this.getHandle(), "OnIsSpeakerMutedChanged", listener)) {
            NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_media_diagnostics_set_on_is_speaker_muted_changed(this.handle, 0L, null));
        }
    }

    private static void OnIsSpeakerVolumeZeroChangedStaticHandler(long cookie, long args) {
        MediaDiagnostics instance = MediaDiagnostics.getInstance(cookie);
        if (instance != null) {
            DiagnosticFlagChangedEvent args_converted = args != 0L ? DiagnosticFlagChangedEvent.getInstance(args, false) : null;
            for (DiagnosticFlagChangedListener listener : instance.OnIsSpeakerVolumeZeroChangedListeners) {
                listener.onDiagnosticFlagChanged(args_converted);
            }
        }
    }

    public void addOnIsSpeakerVolumeZeroChangedListener(DiagnosticFlagChangedListener listener) {
        this.OnIsSpeakerVolumeZeroChangedListeners.add(listener);
        ProjectedObjectEventHandlerCache.addEventHandler(this, this.getHandle(), "OnIsSpeakerVolumeZeroChanged", listener);
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_media_diagnostics_set_on_is_speaker_volume_zero_changed(this.handle, this.getHandle(), this));
    }

    public void removeOnIsSpeakerVolumeZeroChangedListener(DiagnosticFlagChangedListener listener) {
        this.OnIsSpeakerVolumeZeroChangedListeners.remove(listener);
        if (ProjectedObjectEventHandlerCache.removeEventHandler(this, this.getHandle(), "OnIsSpeakerVolumeZeroChanged", listener)) {
            NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_media_diagnostics_set_on_is_speaker_volume_zero_changed(this.handle, 0L, null));
        }
    }

    private static void OnIsNoSpeakerDevicesAvailableChangedStaticHandler(long cookie, long args) {
        MediaDiagnostics instance = MediaDiagnostics.getInstance(cookie);
        if (instance != null) {
            DiagnosticFlagChangedEvent args_converted = args != 0L ? DiagnosticFlagChangedEvent.getInstance(args, false) : null;
            for (DiagnosticFlagChangedListener listener : instance.OnIsNoSpeakerDevicesAvailableChangedListeners) {
                listener.onDiagnosticFlagChanged(args_converted);
            }
        }
    }

    public void addOnIsNoSpeakerDevicesAvailableChangedListener(DiagnosticFlagChangedListener listener) {
        this.OnIsNoSpeakerDevicesAvailableChangedListeners.add(listener);
        ProjectedObjectEventHandlerCache.addEventHandler(this, this.getHandle(), "OnIsNoSpeakerDevicesAvailableChanged", listener);
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_media_diagnostics_set_on_is_no_speaker_devices_available_changed(this.handle, this.getHandle(), this));
    }

    public void removeOnIsNoSpeakerDevicesAvailableChangedListener(DiagnosticFlagChangedListener listener) {
        this.OnIsNoSpeakerDevicesAvailableChangedListeners.remove(listener);
        if (ProjectedObjectEventHandlerCache.removeEventHandler(this, this.getHandle(), "OnIsNoSpeakerDevicesAvailableChanged", listener)) {
            NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_media_diagnostics_set_on_is_no_speaker_devices_available_changed(this.handle, 0L, null));
        }
    }

    private static void OnIsSpeakingWhileMicrophoneIsMutedChangedStaticHandler(long cookie, long args) {
        MediaDiagnostics instance = MediaDiagnostics.getInstance(cookie);
        if (instance != null) {
            DiagnosticFlagChangedEvent args_converted = args != 0L ? DiagnosticFlagChangedEvent.getInstance(args, false) : null;
            for (DiagnosticFlagChangedListener listener : instance.OnIsSpeakingWhileMicrophoneIsMutedChangedListeners) {
                listener.onDiagnosticFlagChanged(args_converted);
            }
        }
    }

    public void addOnIsSpeakingWhileMicrophoneIsMutedChangedListener(DiagnosticFlagChangedListener listener) {
        this.OnIsSpeakingWhileMicrophoneIsMutedChangedListeners.add(listener);
        ProjectedObjectEventHandlerCache.addEventHandler(this, this.getHandle(), "OnIsSpeakingWhileMicrophoneIsMutedChanged", listener);
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_media_diagnostics_set_on_is_speaking_while_microphone_is_muted_changed(this.handle, this.getHandle(), this));
    }

    public void removeOnIsSpeakingWhileMicrophoneIsMutedChangedListener(DiagnosticFlagChangedListener listener) {
        this.OnIsSpeakingWhileMicrophoneIsMutedChangedListeners.remove(listener);
        if (ProjectedObjectEventHandlerCache.removeEventHandler(this, this.getHandle(), "OnIsSpeakingWhileMicrophoneIsMutedChanged", listener)) {
            NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_media_diagnostics_set_on_is_speaking_while_microphone_is_muted_changed(this.handle, 0L, null));
        }
    }

    private static void OnIsNoMicrophoneDevicesAvailableChangedStaticHandler(long cookie, long args) {
        MediaDiagnostics instance = MediaDiagnostics.getInstance(cookie);
        if (instance != null) {
            DiagnosticFlagChangedEvent args_converted = args != 0L ? DiagnosticFlagChangedEvent.getInstance(args, false) : null;
            for (DiagnosticFlagChangedListener listener : instance.OnIsNoMicrophoneDevicesAvailableChangedListeners) {
                listener.onDiagnosticFlagChanged(args_converted);
            }
        }
    }

    public void addOnIsNoMicrophoneDevicesAvailableChangedListener(DiagnosticFlagChangedListener listener) {
        this.OnIsNoMicrophoneDevicesAvailableChangedListeners.add(listener);
        ProjectedObjectEventHandlerCache.addEventHandler(this, this.getHandle(), "OnIsNoMicrophoneDevicesAvailableChanged", listener);
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_media_diagnostics_set_on_is_no_microphone_devices_available_changed(this.handle, this.getHandle(), this));
    }

    public void removeOnIsNoMicrophoneDevicesAvailableChangedListener(DiagnosticFlagChangedListener listener) {
        this.OnIsNoMicrophoneDevicesAvailableChangedListeners.remove(listener);
        if (ProjectedObjectEventHandlerCache.removeEventHandler(this, this.getHandle(), "OnIsNoMicrophoneDevicesAvailableChanged", listener)) {
            NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_media_diagnostics_set_on_is_no_microphone_devices_available_changed(this.handle, 0L, null));
        }
    }

    private static void OnIsMicrophoneBusyChangedStaticHandler(long cookie, long args) {
        MediaDiagnostics instance = MediaDiagnostics.getInstance(cookie);
        if (instance != null) {
            DiagnosticFlagChangedEvent args_converted = args != 0L ? DiagnosticFlagChangedEvent.getInstance(args, false) : null;
            for (DiagnosticFlagChangedListener listener : instance.OnIsMicrophoneBusyChangedListeners) {
                listener.onDiagnosticFlagChanged(args_converted);
            }
        }
    }

    public void addOnIsMicrophoneBusyChangedListener(DiagnosticFlagChangedListener listener) {
        this.OnIsMicrophoneBusyChangedListeners.add(listener);
        ProjectedObjectEventHandlerCache.addEventHandler(this, this.getHandle(), "OnIsMicrophoneBusyChanged", listener);
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_media_diagnostics_set_on_is_microphone_busy_changed(this.handle, this.getHandle(), this));
    }

    public void removeOnIsMicrophoneBusyChangedListener(DiagnosticFlagChangedListener listener) {
        this.OnIsMicrophoneBusyChangedListeners.remove(listener);
        if (ProjectedObjectEventHandlerCache.removeEventHandler(this, this.getHandle(), "OnIsMicrophoneBusyChanged", listener)) {
            NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_media_diagnostics_set_on_is_microphone_busy_changed(this.handle, 0L, null));
        }
    }

    private static void OnIsCameraFrozenChangedStaticHandler(long cookie, long args) {
        MediaDiagnostics instance = MediaDiagnostics.getInstance(cookie);
        if (instance != null) {
            DiagnosticFlagChangedEvent args_converted = args != 0L ? DiagnosticFlagChangedEvent.getInstance(args, false) : null;
            for (DiagnosticFlagChangedListener listener : instance.OnIsCameraFrozenChangedListeners) {
                listener.onDiagnosticFlagChanged(args_converted);
            }
        }
    }

    public void addOnIsCameraFrozenChangedListener(DiagnosticFlagChangedListener listener) {
        this.OnIsCameraFrozenChangedListeners.add(listener);
        ProjectedObjectEventHandlerCache.addEventHandler(this, this.getHandle(), "OnIsCameraFrozenChanged", listener);
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_media_diagnostics_set_on_is_camera_frozen_changed(this.handle, this.getHandle(), this));
    }

    public void removeOnIsCameraFrozenChangedListener(DiagnosticFlagChangedListener listener) {
        this.OnIsCameraFrozenChangedListeners.remove(listener);
        if (ProjectedObjectEventHandlerCache.removeEventHandler(this, this.getHandle(), "OnIsCameraFrozenChanged", listener)) {
            NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_media_diagnostics_set_on_is_camera_frozen_changed(this.handle, 0L, null));
        }
    }

    private static void OnIsCameraStartFailedChangedStaticHandler(long cookie, long args) {
        MediaDiagnostics instance = MediaDiagnostics.getInstance(cookie);
        if (instance != null) {
            DiagnosticFlagChangedEvent args_converted = args != 0L ? DiagnosticFlagChangedEvent.getInstance(args, false) : null;
            for (DiagnosticFlagChangedListener listener : instance.OnIsCameraStartFailedChangedListeners) {
                listener.onDiagnosticFlagChanged(args_converted);
            }
        }
    }

    public void addOnIsCameraStartFailedChangedListener(DiagnosticFlagChangedListener listener) {
        this.OnIsCameraStartFailedChangedListeners.add(listener);
        ProjectedObjectEventHandlerCache.addEventHandler(this, this.getHandle(), "OnIsCameraStartFailedChanged", listener);
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_media_diagnostics_set_on_is_camera_start_failed_changed(this.handle, this.getHandle(), this));
    }

    public void removeOnIsCameraStartFailedChangedListener(DiagnosticFlagChangedListener listener) {
        this.OnIsCameraStartFailedChangedListeners.remove(listener);
        if (ProjectedObjectEventHandlerCache.removeEventHandler(this, this.getHandle(), "OnIsCameraStartFailedChanged", listener)) {
            NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_media_diagnostics_set_on_is_camera_start_failed_changed(this.handle, 0L, null));
        }
    }

    private static void OnIsCameraStartTimedOutChangedStaticHandler(long cookie, long args) {
        MediaDiagnostics instance = MediaDiagnostics.getInstance(cookie);
        if (instance != null) {
            DiagnosticFlagChangedEvent args_converted = args != 0L ? DiagnosticFlagChangedEvent.getInstance(args, false) : null;
            for (DiagnosticFlagChangedListener listener : instance.OnIsCameraStartTimedOutChangedListeners) {
                listener.onDiagnosticFlagChanged(args_converted);
            }
        }
    }

    public void addOnIsCameraStartTimedOutChangedListener(DiagnosticFlagChangedListener listener) {
        this.OnIsCameraStartTimedOutChangedListeners.add(listener);
        ProjectedObjectEventHandlerCache.addEventHandler(this, this.getHandle(), "OnIsCameraStartTimedOutChanged", listener);
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_media_diagnostics_set_on_is_camera_start_timed_out_changed(this.handle, this.getHandle(), this));
    }

    public void removeOnIsCameraStartTimedOutChangedListener(DiagnosticFlagChangedListener listener) {
        this.OnIsCameraStartTimedOutChangedListeners.remove(listener);
        if (ProjectedObjectEventHandlerCache.removeEventHandler(this, this.getHandle(), "OnIsCameraStartTimedOutChanged", listener)) {
            NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_media_diagnostics_set_on_is_camera_start_timed_out_changed(this.handle, 0L, null));
        }
    }

    private static void OnIsMicrophoneNotFunctioningChangedStaticHandler(long cookie, long args) {
        MediaDiagnostics instance = MediaDiagnostics.getInstance(cookie);
        if (instance != null) {
            DiagnosticFlagChangedEvent args_converted = args != 0L ? DiagnosticFlagChangedEvent.getInstance(args, false) : null;
            for (DiagnosticFlagChangedListener listener : instance.OnIsMicrophoneNotFunctioningChangedListeners) {
                listener.onDiagnosticFlagChanged(args_converted);
            }
        }
    }

    public void addOnIsMicrophoneNotFunctioningChangedListener(DiagnosticFlagChangedListener listener) {
        this.OnIsMicrophoneNotFunctioningChangedListeners.add(listener);
        ProjectedObjectEventHandlerCache.addEventHandler(this, this.getHandle(), "OnIsMicrophoneNotFunctioningChanged", listener);
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_media_diagnostics_set_on_is_microphone_not_functioning_changed(this.handle, this.getHandle(), this));
    }

    public void removeOnIsMicrophoneNotFunctioningChangedListener(DiagnosticFlagChangedListener listener) {
        this.OnIsMicrophoneNotFunctioningChangedListeners.remove(listener);
        if (ProjectedObjectEventHandlerCache.removeEventHandler(this, this.getHandle(), "OnIsMicrophoneNotFunctioningChanged", listener)) {
            NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_media_diagnostics_set_on_is_microphone_not_functioning_changed(this.handle, 0L, null));
        }
    }

    private static void OnIsMicrophoneMutedUnexpectedlyChangedStaticHandler(long cookie, long args) {
        MediaDiagnostics instance = MediaDiagnostics.getInstance(cookie);
        if (instance != null) {
            DiagnosticFlagChangedEvent args_converted = args != 0L ? DiagnosticFlagChangedEvent.getInstance(args, false) : null;
            for (DiagnosticFlagChangedListener listener : instance.OnIsMicrophoneMutedUnexpectedlyChangedListeners) {
                listener.onDiagnosticFlagChanged(args_converted);
            }
        }
    }

    public void addOnIsMicrophoneMutedUnexpectedlyChangedListener(DiagnosticFlagChangedListener listener) {
        this.OnIsMicrophoneMutedUnexpectedlyChangedListeners.add(listener);
        ProjectedObjectEventHandlerCache.addEventHandler(this, this.getHandle(), "OnIsMicrophoneMutedUnexpectedlyChanged", listener);
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_media_diagnostics_set_on_is_microphone_muted_unexpectedly_changed(this.handle, this.getHandle(), this));
    }

    public void removeOnIsMicrophoneMutedUnexpectedlyChangedListener(DiagnosticFlagChangedListener listener) {
        this.OnIsMicrophoneMutedUnexpectedlyChangedListeners.remove(listener);
        if (ProjectedObjectEventHandlerCache.removeEventHandler(this, this.getHandle(), "OnIsMicrophoneMutedUnexpectedlyChanged", listener)) {
            NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_media_diagnostics_set_on_is_microphone_muted_unexpectedly_changed(this.handle, 0L, null));
        }
    }

    private static void OnIsCameraPermissionDeniedChangedStaticHandler(long cookie, long args) {
        MediaDiagnostics instance = MediaDiagnostics.getInstance(cookie);
        if (instance != null) {
            DiagnosticFlagChangedEvent args_converted = args != 0L ? DiagnosticFlagChangedEvent.getInstance(args, false) : null;
            for (DiagnosticFlagChangedListener listener : instance.OnIsCameraPermissionDeniedChangedListeners) {
                listener.onDiagnosticFlagChanged(args_converted);
            }
        }
    }

    public void addOnIsCameraPermissionDeniedChangedListener(DiagnosticFlagChangedListener listener) {
        this.OnIsCameraPermissionDeniedChangedListeners.add(listener);
        ProjectedObjectEventHandlerCache.addEventHandler(this, this.getHandle(), "OnIsCameraPermissionDeniedChanged", listener);
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_media_diagnostics_set_on_is_camera_permission_denied_changed(this.handle, this.getHandle(), this));
    }

    public void removeOnIsCameraPermissionDeniedChangedListener(DiagnosticFlagChangedListener listener) {
        this.OnIsCameraPermissionDeniedChangedListeners.remove(listener);
        if (ProjectedObjectEventHandlerCache.removeEventHandler(this, this.getHandle(), "OnIsCameraPermissionDeniedChanged", listener)) {
            NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_media_diagnostics_set_on_is_camera_permission_denied_changed(this.handle, 0L, null));
        }
    }

    static MediaDiagnostics getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.MediaDiagnostics, MediaDiagnostics.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_media_diagnostics_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.MediaDiagnostics, MediaDiagnostics.class, false);
    }

    private static MediaDiagnostics getInstance(long cookie) {
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.MediaDiagnostics, MediaDiagnostics.class, false);
    }

    void restoreEventHandlers() {
        for (Object eventListener : ProjectedObjectEventHandlerCache.getEventHandlers(this, this.getHandle(), "OnIsSpeakerNotFunctioningChanged")) {
            this.addOnIsSpeakerNotFunctioningChangedListener((DiagnosticFlagChangedListener)eventListener);
        }
        for (Object eventListener : ProjectedObjectEventHandlerCache.getEventHandlers(this, this.getHandle(), "OnIsSpeakerBusyChanged")) {
            this.addOnIsSpeakerBusyChangedListener((DiagnosticFlagChangedListener)eventListener);
        }
        for (Object eventListener : ProjectedObjectEventHandlerCache.getEventHandlers(this, this.getHandle(), "OnIsSpeakerMutedChanged")) {
            this.addOnIsSpeakerMutedChangedListener((DiagnosticFlagChangedListener)eventListener);
        }
        for (Object eventListener : ProjectedObjectEventHandlerCache.getEventHandlers(this, this.getHandle(), "OnIsSpeakerVolumeZeroChanged")) {
            this.addOnIsSpeakerVolumeZeroChangedListener((DiagnosticFlagChangedListener)eventListener);
        }
        for (Object eventListener : ProjectedObjectEventHandlerCache.getEventHandlers(this, this.getHandle(), "OnIsNoSpeakerDevicesAvailableChanged")) {
            this.addOnIsNoSpeakerDevicesAvailableChangedListener((DiagnosticFlagChangedListener)eventListener);
        }
        for (Object eventListener : ProjectedObjectEventHandlerCache.getEventHandlers(this, this.getHandle(), "OnIsSpeakingWhileMicrophoneIsMutedChanged")) {
            this.addOnIsSpeakingWhileMicrophoneIsMutedChangedListener((DiagnosticFlagChangedListener)eventListener);
        }
        for (Object eventListener : ProjectedObjectEventHandlerCache.getEventHandlers(this, this.getHandle(), "OnIsNoMicrophoneDevicesAvailableChanged")) {
            this.addOnIsNoMicrophoneDevicesAvailableChangedListener((DiagnosticFlagChangedListener)eventListener);
        }
        for (Object eventListener : ProjectedObjectEventHandlerCache.getEventHandlers(this, this.getHandle(), "OnIsMicrophoneBusyChanged")) {
            this.addOnIsMicrophoneBusyChangedListener((DiagnosticFlagChangedListener)eventListener);
        }
        for (Object eventListener : ProjectedObjectEventHandlerCache.getEventHandlers(this, this.getHandle(), "OnIsCameraFrozenChanged")) {
            this.addOnIsCameraFrozenChangedListener((DiagnosticFlagChangedListener)eventListener);
        }
        for (Object eventListener : ProjectedObjectEventHandlerCache.getEventHandlers(this, this.getHandle(), "OnIsCameraStartFailedChanged")) {
            this.addOnIsCameraStartFailedChangedListener((DiagnosticFlagChangedListener)eventListener);
        }
        for (Object eventListener : ProjectedObjectEventHandlerCache.getEventHandlers(this, this.getHandle(), "OnIsCameraStartTimedOutChanged")) {
            this.addOnIsCameraStartTimedOutChangedListener((DiagnosticFlagChangedListener)eventListener);
        }
        for (Object eventListener : ProjectedObjectEventHandlerCache.getEventHandlers(this, this.getHandle(), "OnIsMicrophoneNotFunctioningChanged")) {
            this.addOnIsMicrophoneNotFunctioningChangedListener((DiagnosticFlagChangedListener)eventListener);
        }
        for (Object eventListener : ProjectedObjectEventHandlerCache.getEventHandlers(this, this.getHandle(), "OnIsMicrophoneMutedUnexpectedlyChanged")) {
            this.addOnIsMicrophoneMutedUnexpectedlyChangedListener((DiagnosticFlagChangedListener)eventListener);
        }
        for (Object eventListener : ProjectedObjectEventHandlerCache.getEventHandlers(this, this.getHandle(), "OnIsCameraPermissionDeniedChanged")) {
            this.addOnIsCameraPermissionDeniedChangedListener((DiagnosticFlagChangedListener)eventListener);
        }
    }

    public MediaDiagnosticValues getLatestDiagnostics() {
        return this.getLatestInternal();
    }
}

