/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import android.content.Context;
import com.azure.android.communication.calling.CallingCommunicationErrors;
import com.azure.android.communication.calling.CallingCommunicationException;
import com.azure.android.communication.calling.CreateViewOptions;
import com.azure.android.communication.calling.IVideoStreamRenderer;
import com.azure.android.communication.calling.LocalOutgoingVideoStreamView;
import com.azure.android.communication.calling.LocalVideoStream;
import com.azure.android.communication.calling.Log;
import com.azure.android.communication.calling.RendererListener;
import com.azure.android.communication.calling.StreamSize;
import com.azure.android.communication.calling.VideoBindingEventStateChangedEvent;
import com.azure.android.communication.calling.VideoBindingEventStateChangedListener;
import com.azure.android.communication.calling.VideoDeviceInfo;
import com.azure.android.communication.calling.VideoDeviceInfoUpdatedEvent;
import com.azure.android.communication.calling.VideoDeviceInfoUpdatedListener;
import com.azure.android.communication.calling.VideoFrameSizeChangedEvent;
import com.azure.android.communication.calling.VideoFrameSizeChangedListener;
import com.azure.android.communication.calling.VideoStreamView;
import java.io.Closeable;
import java.io.IOException;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.UUID;
import java9.util.concurrent.CompletableFuture;

class LocalOutgoingVideoStreamRenderer
implements IVideoStreamRenderer,
VideoBindingEventStateChangedListener,
VideoFrameSizeChangedListener,
VideoDeviceInfoUpdatedListener,
Closeable {
    private static final String TAG = "LocalOutgoingVideoStreamRenderer";
    private final Queue<CompletableFuture<Void>> switchSourcePendingCallbackQueue;
    private final Context context;
    private final LocalVideoStream localVideoStream;
    private final String rendererId;
    private LocalOutgoingVideoStreamView videoStreamView;
    private RendererListener rendererListener;
    private boolean isStarted = false;
    private boolean isFirstFrame = true;

    LocalOutgoingVideoStreamRenderer(Context context, LocalVideoStream localVideoStream) {
        this.context = context;
        this.localVideoStream = localVideoStream;
        this.localVideoStream.addOnBindingEventStateChangedListenerInternal(this);
        this.localVideoStream.addOnFrameSizeChangedListenerInternal(this);
        this.localVideoStream.addOnDeviceInfoUpdatedListenerInternal(this);
        this.rendererId = UUID.randomUUID().toString();
        this.switchSourcePendingCallbackQueue = new PriorityQueue<CompletableFuture<Void>>();
    }

    @Override
    public VideoStreamView StartPreview(CreateViewOptions options) {
        if (this.isStarted) {
            throw new CallingCommunicationException(CallingCommunicationErrors.MULTIPLE_VIEWS_NOT_SUPPORTED);
        }
        this.isStarted = true;
        this.videoStreamView = new LocalOutgoingVideoStreamView(this.context, this.localVideoStream, options.getScalingMode());
        Log.debug1(TAG, "StartPreview rendererId: %s localVideoStream: %d", this.rendererId, System.identityHashCode(this.localVideoStream));
        this.localVideoStream.startPreviewNative(this.rendererId);
        return this.videoStreamView;
    }

    @Override
    public void StopPreview() {
        if (this.isStarted) {
            this.isStarted = false;
            Log.debug1(TAG, "StopPreview rendererId: %s localVideoStream: %d", this.rendererId, System.identityHashCode(this.localVideoStream));
            this.localVideoStream.stopPreviewNative(this.rendererId);
        }
    }

    void SwitchVideoDeviceInfo(VideoDeviceInfo videoDeviceInfo, CompletableFuture<Void> completableFuture) {
        if (this.isStarted) {
            this.switchSourcePendingCallbackQueue.add(completableFuture);
            Log.debug1(TAG, "SwitchVideoDeviceInfo rendererId: %s localVideoStream: %d", this.rendererId, System.identityHashCode(this.localVideoStream));
            this.videoStreamView.UnregisterSurfaceTexture();
            this.localVideoStream.switchVideoDeviceInfoNative(this.rendererId, videoDeviceInfo);
        }
    }

    @Override
    public void onVideoBindingEventStateChanged(VideoBindingEventStateChangedEvent args) {
        if (!this.rendererId.equals(args.getRendererId())) {
            Log.debug1(TAG, "OnVideoBindingEventStateChanged returning because the event belongs to a different renderer", new Object[0]);
            return;
        }
        Log.debug1(TAG, "OnVideoBindingEventStateChanged state: %s, rendererId: %s, videoBindingEventId: %s", args.getState().toString(), args.getRendererId(), args.getVideoBindingEventId());
        switch (args.getState()) {
            case CREATED: {
                if (!this.isStarted) break;
                this.videoStreamView.Init(this.localVideoStream.getPreviewId());
                break;
            }
            case RELEASED: {
                this.Dispose();
                break;
            }
            case FAILED: {
                this.Dispose();
                if (this.rendererListener == null) break;
                this.rendererListener.onRendererFailedToStart();
            }
        }
    }

    @Override
    public void onVideoFrameSizeChanged(VideoFrameSizeChangedEvent args) {
        Log.debug1(TAG, "OnFrameSizeChanged previewVideoId: %d, w: %d x h: %d", this.localVideoStream.getPreviewId(), args.getWidth(), args.getHeight());
        this.videoStreamView.UpdateVideoFrameSize(args.getWidth(), args.getHeight());
        if (this.rendererListener != null && this.isFirstFrame) {
            this.isFirstFrame = false;
            this.rendererListener.onFirstFrameRendered();
        }
    }

    @Override
    public void onVideoDeviceInfoUpdated(VideoDeviceInfoUpdatedEvent args) {
        if (!this.rendererId.equals(args.getRendererId())) {
            Log.debug1(TAG, "OnVideoDeviceInfoUpdated returning because the event belongs to a different renderer", new Object[0]);
            return;
        }
        Log.debug1(TAG, "OnVideoDeviceInfoUpdated", new Object[0]);
        if (!this.switchSourcePendingCallbackQueue.isEmpty()) {
            CompletableFuture<Void> completableFuture = this.switchSourcePendingCallbackQueue.remove();
            completableFuture.complete(null);
        }
    }

    @Override
    public void SetRendererListener(RendererListener rendererListener) {
        this.rendererListener = rendererListener;
    }

    @Override
    public StreamSize GetVideoFrameSize() {
        return this.videoStreamView.GetVideoFrameSize();
    }

    private void Dispose() {
        if (!this.isStarted) {
            Log.debug1(TAG, "Dispose", new Object[0]);
            this.localVideoStream.removeOnBindingEventStateChangedListenerInternal(this);
            this.localVideoStream.removeOnFrameSizeChangedListenerInternal(this);
            this.videoStreamView.Dispose();
            this.videoStreamView = null;
        }
    }

    @Override
    public void close() throws IOException {
        this.Dispose();
    }
}

