/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import com.azure.android.communication.calling.RawAudioBuffer;
import com.azure.android.communication.calling.RawIncomingAudioStreamProperties;

public final class IncomingMixedAudioEvent {
    long handle;

    IncomingMixedAudioEvent(long ahandle, boolean transfer) {
        this.handle = ahandle;
        if (!transfer) {
            NativeLibrary.sam_incoming_mixed_audio_event_args_addref(ahandle);
        }
        ProjectedObjectCache.add(this, this.handle);
    }

    long getHandle() {
        return this.handle;
    }

    protected void finalize() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_incoming_mixed_audio_event_args_release(this.handle));
        this.handle = 0L;
    }

    public RawIncomingAudioStreamProperties getStreamProperties() {
        Out<Long> result_handle = new Out<Long>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_incoming_mixed_audio_event_args_get_stream_properties(this.handle, result_handle));
        RawIncomingAudioStreamProperties result_object = (Long)result_handle.value != 0L ? RawIncomingAudioStreamProperties.getInstance((Long)result_handle.value, true) : null;
        return result_object;
    }

    public RawAudioBuffer getAudioBuffer() {
        Out<Long> result_handle = new Out<Long>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_incoming_mixed_audio_event_args_get_audio_buffer(this.handle, result_handle));
        RawAudioBuffer result_object = (Long)result_handle.value != 0L ? RawAudioBuffer.getInstance((Long)result_handle.value, true) : null;
        return result_object;
    }

    static IncomingMixedAudioEvent getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.IncomingMixedAudioEvent, IncomingMixedAudioEvent.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_incoming_mixed_audio_event_args_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.IncomingMixedAudioEvent, IncomingMixedAudioEvent.class, false);
    }
}

