/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.IncomingAudioStatistics;
import com.azure.android.communication.calling.IncomingDataChannelStatistics;
import com.azure.android.communication.calling.IncomingScreenShareStatistics;
import com.azure.android.communication.calling.IncomingVideoStatistics;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class IncomingMediaStatistics {
    long handle;

    IncomingMediaStatistics(long ahandle, boolean transfer) {
        this.handle = ahandle;
        if (!transfer) {
            NativeLibrary.sam_incoming_media_statistics_addref(ahandle);
        }
        ProjectedObjectCache.add(this, this.handle);
    }

    long getHandle() {
        return this.handle;
    }

    protected void finalize() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_incoming_media_statistics_release(this.handle));
        this.handle = 0L;
    }

    private List<IncomingAudioStatistics> getAudioInternal() {
        Out<long[]> result = new Out<long[]>();
        Out<Integer> result_length = new Out<Integer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_incoming_media_statistics_get_audio_internal(this.handle, result, result_length));
        ArrayList<IncomingAudioStatistics> resultList = new ArrayList<IncomingAudioStatistics>();
        long[] resultArray = (long[])result.value;
        for (int i = 0; i < resultArray.length; ++i) {
            resultList.add(IncomingAudioStatistics.getInstance(resultArray[i], true));
        }
        List<IncomingAudioStatistics> resultImmutable = Collections.unmodifiableList(resultList);
        return resultImmutable;
    }

    private List<IncomingVideoStatistics> getVideoInternal() {
        Out<long[]> result = new Out<long[]>();
        Out<Integer> result_length = new Out<Integer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_incoming_media_statistics_get_video_internal(this.handle, result, result_length));
        ArrayList<IncomingVideoStatistics> resultList = new ArrayList<IncomingVideoStatistics>();
        long[] resultArray = (long[])result.value;
        for (int i = 0; i < resultArray.length; ++i) {
            resultList.add(IncomingVideoStatistics.getInstance(resultArray[i], true));
        }
        List<IncomingVideoStatistics> resultImmutable = Collections.unmodifiableList(resultList);
        return resultImmutable;
    }

    private List<IncomingScreenShareStatistics> getScreenShareInternal() {
        Out<long[]> result = new Out<long[]>();
        Out<Integer> result_length = new Out<Integer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_incoming_media_statistics_get_screen_share_internal(this.handle, result, result_length));
        ArrayList<IncomingScreenShareStatistics> resultList = new ArrayList<IncomingScreenShareStatistics>();
        long[] resultArray = (long[])result.value;
        for (int i = 0; i < resultArray.length; ++i) {
            resultList.add(IncomingScreenShareStatistics.getInstance(resultArray[i], true));
        }
        List<IncomingScreenShareStatistics> resultImmutable = Collections.unmodifiableList(resultList);
        return resultImmutable;
    }

    private List<IncomingDataChannelStatistics> getDataChannelInternal() {
        Out<long[]> result = new Out<long[]>();
        Out<Integer> result_length = new Out<Integer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_incoming_media_statistics_get_data_channel_internal(this.handle, result, result_length));
        ArrayList<IncomingDataChannelStatistics> resultList = new ArrayList<IncomingDataChannelStatistics>();
        long[] resultArray = (long[])result.value;
        for (int i = 0; i < resultArray.length; ++i) {
            resultList.add(IncomingDataChannelStatistics.getInstance(resultArray[i], true));
        }
        List<IncomingDataChannelStatistics> resultImmutable = Collections.unmodifiableList(resultList);
        return resultImmutable;
    }

    static IncomingMediaStatistics getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.IncomingMediaStatistics, IncomingMediaStatistics.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_incoming_media_statistics_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.IncomingMediaStatistics, IncomingMediaStatistics.class, false);
    }

    public List<IncomingAudioStatistics> getAudioStatistics() {
        return this.getAudioInternal();
    }

    public List<IncomingVideoStatistics> getVideoStatistics() {
        return this.getVideoInternal();
    }

    public List<IncomingScreenShareStatistics> getScreenShareStatistics() {
        return this.getScreenShareInternal();
    }

    public List<IncomingDataChannelStatistics> getDataChannelStatistics() {
        return this.getDataChannelInternal();
    }
}

