/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.Constants;
import com.azure.android.communication.common.CommunicationCloudEnvironment;
import com.azure.android.communication.common.CommunicationIdentifier;
import com.azure.android.communication.common.CommunicationUserIdentifier;
import com.azure.android.communication.common.MicrosoftTeamsUserIdentifier;
import com.azure.android.communication.common.PhoneNumberIdentifier;
import com.azure.android.communication.common.UnknownIdentifier;
import java.util.ArrayList;
import java.util.List;

class IdentifierHelpers {
    IdentifierHelpers() {
    }

    static String[] convertIdentifiersToMris(Iterable<CommunicationIdentifier> iterableIdentifiers) {
        ArrayList<String> identifiersList = new ArrayList<String>();
        for (CommunicationIdentifier communicationIdentifier : iterableIdentifiers) {
            identifiersList.add(IdentifierHelpers.toMRI(communicationIdentifier));
        }
        String[] identifiers = new String[identifiersList.size()];
        return identifiersList.toArray(identifiers);
    }

    static List<CommunicationIdentifier> convertMrisToIdentifiers(String[] mris) {
        ArrayList<CommunicationIdentifier> identifiersList = new ArrayList<CommunicationIdentifier>();
        for (String mri : mris) {
            identifiersList.add(IdentifierHelpers.from(mri));
        }
        return identifiersList;
    }

    static CommunicationIdentifier from(String mri) {
        if (mri.startsWith(Constants.PHONE_MRI_PREFIX)) {
            return new PhoneNumberIdentifier(mri.substring(2));
        }
        if (mri.startsWith(Constants.TEAMS_PUBLIC_CLOUD_MRI_PREFIX)) {
            return new MicrosoftTeamsUserIdentifier(mri.substring(Constants.TEAMS_PUBLIC_CLOUD_MRI_PREFIX.length()), false).setCloudEnvironment(CommunicationCloudEnvironment.PUBLIC);
        }
        if (mri.startsWith(Constants.TEAMS_DOD_CLOUD_MRI_PREFIX)) {
            return new MicrosoftTeamsUserIdentifier(mri.substring(Constants.TEAMS_DOD_CLOUD_MRI_PREFIX.length()), false).setCloudEnvironment(CommunicationCloudEnvironment.DOD);
        }
        if (mri.startsWith(Constants.TEAMS_GCCH_CLOUD_MRI_PREFIX)) {
            return new MicrosoftTeamsUserIdentifier(mri.substring(Constants.TEAMS_GCCH_CLOUD_MRI_PREFIX.length()), false).setCloudEnvironment(CommunicationCloudEnvironment.GCCH);
        }
        if (mri.startsWith(Constants.TEAMS_ANONYMOUS_MRI_PREFIX)) {
            return new MicrosoftTeamsUserIdentifier(mri.substring(Constants.TEAMS_ANONYMOUS_MRI_PREFIX.length()), true).setCloudEnvironment(null);
        }
        if (mri.startsWith(Constants.ACS_PUBLIC_MRI_PREFIX) || mri.startsWith(Constants.ACS_PUBLIC_LEGACY_MRI_PREFIX) || mri.startsWith(Constants.ACS_DOD_MRI_PREFIX) || mri.startsWith(Constants.ACS_GCCH_MRI_PREFIX) || mri.startsWith(Constants.ACS_AG08_MRI_PREFIX) || mri.startsWith(Constants.ACS_AG09_MRI_PREFIX)) {
            return new CommunicationUserIdentifier(mri);
        }
        if (mri == null) {
            return new UnknownIdentifier("null");
        }
        if (mri.isEmpty()) {
            return new UnknownIdentifier("empty");
        }
        return new UnknownIdentifier(mri);
    }

    static String toMRI(CommunicationIdentifier identifier) {
        if (identifier instanceof CommunicationUserIdentifier) {
            return ((CommunicationUserIdentifier)identifier).getId();
        }
        if (identifier instanceof PhoneNumberIdentifier) {
            return "4:" + ((PhoneNumberIdentifier)identifier).getPhoneNumber();
        }
        if (identifier instanceof MicrosoftTeamsUserIdentifier) {
            MicrosoftTeamsUserIdentifier teamsUserIdentifier = (MicrosoftTeamsUserIdentifier)identifier;
            if (teamsUserIdentifier.getRawId() != null && !teamsUserIdentifier.getRawId().isEmpty() && teamsUserIdentifier.getRawId().startsWith(Constants.SKYPE_MRI_PREFIX)) {
                return teamsUserIdentifier.getRawId();
            }
            if (CommunicationCloudEnvironment.PUBLIC.equals((Object)teamsUserIdentifier.getCloudEnvironment())) {
                return Constants.TEAMS_PUBLIC_CLOUD_MRI_PREFIX + teamsUserIdentifier.getUserId();
            }
            if (CommunicationCloudEnvironment.DOD.equals((Object)teamsUserIdentifier.getCloudEnvironment())) {
                return Constants.TEAMS_DOD_CLOUD_MRI_PREFIX + teamsUserIdentifier.getUserId();
            }
            if (CommunicationCloudEnvironment.GCCH.equals((Object)teamsUserIdentifier.getCloudEnvironment())) {
                return Constants.TEAMS_GCCH_CLOUD_MRI_PREFIX + teamsUserIdentifier.getUserId();
            }
            return Constants.TEAMS_ANONYMOUS_MRI_PREFIX + teamsUserIdentifier.getUserId();
        }
        return ((UnknownIdentifier)identifier).getId();
    }
}

