/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.AcceptCallOptions;
import com.azure.android.communication.calling.AcceptTeamsCallOptions;
import com.azure.android.communication.calling.BackgroundBlurEffect;
import com.azure.android.communication.calling.BackgroundReplacementEffect;
import com.azure.android.communication.calling.Call;
import com.azure.android.communication.calling.CallAgent;
import com.azure.android.communication.calling.CallAudioStream;
import com.azure.android.communication.calling.CallCaptions;
import com.azure.android.communication.calling.CallFeature;
import com.azure.android.communication.calling.CallOptions;
import com.azure.android.communication.calling.CallVideoStream;
import com.azure.android.communication.calling.CaptionsCallFeature;
import com.azure.android.communication.calling.CommonCall;
import com.azure.android.communication.calling.CommonCallAgent;
import com.azure.android.communication.calling.CommonIncomingCall;
import com.azure.android.communication.calling.DataChannelCallFeature;
import com.azure.android.communication.calling.DominantSpeakersCallFeature;
import com.azure.android.communication.calling.GroupCallLocator;
import com.azure.android.communication.calling.HandleType;
import com.azure.android.communication.calling.IncomingAudioStream;
import com.azure.android.communication.calling.IncomingCall;
import com.azure.android.communication.calling.IncomingVideoStream;
import com.azure.android.communication.calling.JoinCallOptions;
import com.azure.android.communication.calling.JoinMeetingLocator;
import com.azure.android.communication.calling.JoinTeamsCallOptions;
import com.azure.android.communication.calling.JoinTeamsMeetingLocator;
import com.azure.android.communication.calling.LocalOutgoingAudioStream;
import com.azure.android.communication.calling.LocalUserDiagnosticsCallFeature;
import com.azure.android.communication.calling.LocalVideoEffectsFeature;
import com.azure.android.communication.calling.LocalVideoStream;
import com.azure.android.communication.calling.LocalVideoStreamFeature;
import com.azure.android.communication.calling.MediaStatisticsCallFeature;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.OutgoingAudioStream;
import com.azure.android.communication.calling.OutgoingVideoStream;
import com.azure.android.communication.calling.RaiseHandCallFeature;
import com.azure.android.communication.calling.RawAudioStreamOptions;
import com.azure.android.communication.calling.RawAudioStreamProperties;
import com.azure.android.communication.calling.RawIncomingAudioStream;
import com.azure.android.communication.calling.RawIncomingAudioStreamOptions;
import com.azure.android.communication.calling.RawIncomingAudioStreamProperties;
import com.azure.android.communication.calling.RawIncomingVideoStream;
import com.azure.android.communication.calling.RawOutgoingAudioStream;
import com.azure.android.communication.calling.RawOutgoingAudioStreamOptions;
import com.azure.android.communication.calling.RawOutgoingAudioStreamProperties;
import com.azure.android.communication.calling.RawOutgoingVideoStream;
import com.azure.android.communication.calling.RawVideoFrame;
import com.azure.android.communication.calling.RawVideoFrameBuffer;
import com.azure.android.communication.calling.RecordingCallFeature;
import com.azure.android.communication.calling.RemoteIncomingAudioStream;
import com.azure.android.communication.calling.RemoteVideoStream;
import com.azure.android.communication.calling.RoomCallLocator;
import com.azure.android.communication.calling.ScreenShareOutgoingVideoStream;
import com.azure.android.communication.calling.SpotlightCallFeature;
import com.azure.android.communication.calling.StartCallOptions;
import com.azure.android.communication.calling.StartTeamsCallOptions;
import com.azure.android.communication.calling.TeamsCall;
import com.azure.android.communication.calling.TeamsCallAgent;
import com.azure.android.communication.calling.TeamsCaptions;
import com.azure.android.communication.calling.TeamsIncomingCall;
import com.azure.android.communication.calling.TeamsMeetingCoordinatesLocator;
import com.azure.android.communication.calling.TeamsMeetingLinkLocator;
import com.azure.android.communication.calling.TranscriptionCallFeature;
import com.azure.android.communication.calling.VideoEffect;
import com.azure.android.communication.calling.VirtualOutgoingVideoStream;

class Factories {
    Factories() {
    }

    static CallOptions CallOptionsFactory(long handle, boolean transfer) {
        CallOptions result_object;
        if (handle == 0L) {
            return null;
        }
        Out<HandleType> result = new Out<HandleType>();
        NativeLibraryHelpers.checkStatus(handle, NativeLibrary.sam_get_handle_type(handle, result));
        switch ((HandleType)((Object)result.value)) {
            case JOIN_TEAMS_CALL_OPTIONS: {
                result_object = JoinTeamsCallOptions.getInstance(handle, transfer);
                break;
            }
            case JOIN_CALL_OPTIONS: {
                result_object = JoinCallOptions.getInstance(handle, transfer);
                break;
            }
            case ACCEPT_TEAMS_CALL_OPTIONS: {
                result_object = AcceptTeamsCallOptions.getInstance(handle, transfer);
                break;
            }
            case ACCEPT_CALL_OPTIONS: {
                result_object = AcceptCallOptions.getInstance(handle, transfer);
                break;
            }
            case START_CALL_OPTIONS: {
                result_object = StartCallOptions.getInstance(handle, transfer);
                break;
            }
            case START_TEAMS_CALL_OPTIONS: {
                result_object = StartTeamsCallOptions.getInstance(handle, transfer);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return result_object;
    }

    static JoinMeetingLocator JoinMeetingLocatorFactory(long handle, boolean transfer) {
        JoinMeetingLocator result_object;
        if (handle == 0L) {
            return null;
        }
        Out<HandleType> result = new Out<HandleType>();
        NativeLibraryHelpers.checkStatus(handle, NativeLibrary.sam_get_handle_type(handle, result));
        switch ((HandleType)((Object)result.value)) {
            case GROUP_CALL_LOCATOR: {
                result_object = GroupCallLocator.getInstance(handle, transfer);
                break;
            }
            case TEAMS_MEETING_COORDINATES_LOCATOR: {
                result_object = TeamsMeetingCoordinatesLocator.getInstance(handle, transfer);
                break;
            }
            case TEAMS_MEETING_LINK_LOCATOR: {
                result_object = TeamsMeetingLinkLocator.getInstance(handle, transfer);
                break;
            }
            case ROOM_CALL_LOCATOR: {
                result_object = RoomCallLocator.getInstance(handle, transfer);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return result_object;
    }

    static JoinTeamsMeetingLocator JoinTeamsMeetingLocatorFactory(long handle, boolean transfer) {
        JoinTeamsMeetingLocator result_object;
        if (handle == 0L) {
            return null;
        }
        Out<HandleType> result = new Out<HandleType>();
        NativeLibraryHelpers.checkStatus(handle, NativeLibrary.sam_get_handle_type(handle, result));
        switch ((HandleType)((Object)result.value)) {
            case TEAMS_MEETING_COORDINATES_LOCATOR: {
                result_object = TeamsMeetingCoordinatesLocator.getInstance(handle, transfer);
                break;
            }
            case TEAMS_MEETING_LINK_LOCATOR: {
                result_object = TeamsMeetingLinkLocator.getInstance(handle, transfer);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return result_object;
    }

    static CommonCallAgent CommonCallAgentFactory(long handle, boolean transfer) {
        CommonCallAgent result_object;
        if (handle == 0L) {
            return null;
        }
        Out<HandleType> result = new Out<HandleType>();
        NativeLibraryHelpers.checkStatus(handle, NativeLibrary.sam_get_handle_type(handle, result));
        switch ((HandleType)((Object)result.value)) {
            case CALL_AGENT: {
                result_object = CallAgent.getInstance(handle, transfer);
                break;
            }
            case TEAMS_CALL_AGENT: {
                result_object = TeamsCallAgent.getInstance(handle, transfer);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return result_object;
    }

    static CommonIncomingCall CommonIncomingCallFactory(long handle, boolean transfer) {
        CommonIncomingCall result_object;
        if (handle == 0L) {
            return null;
        }
        Out<HandleType> result = new Out<HandleType>();
        NativeLibraryHelpers.checkStatus(handle, NativeLibrary.sam_get_handle_type(handle, result));
        switch ((HandleType)((Object)result.value)) {
            case INCOMING_CALL: {
                result_object = IncomingCall.getInstance(handle, transfer);
                break;
            }
            case TEAMS_INCOMING_CALL: {
                result_object = TeamsIncomingCall.getInstance(handle, transfer);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return result_object;
    }

    static CommonCall CommonCallFactory(long handle, boolean transfer) {
        CommonCall result_object;
        if (handle == 0L) {
            return null;
        }
        Out<HandleType> result = new Out<HandleType>();
        NativeLibraryHelpers.checkStatus(handle, NativeLibrary.sam_get_handle_type(handle, result));
        switch ((HandleType)((Object)result.value)) {
            case CALL: {
                result_object = Call.getInstance(handle, transfer);
                break;
            }
            case TEAMS_CALL: {
                result_object = TeamsCall.getInstance(handle, transfer);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return result_object;
    }

    static CallFeature CallFeatureFactory(long handle, boolean transfer) {
        CallFeature result_object;
        if (handle == 0L) {
            return null;
        }
        Out<HandleType> result = new Out<HandleType>();
        NativeLibraryHelpers.checkStatus(handle, NativeLibrary.sam_get_handle_type(handle, result));
        switch ((HandleType)((Object)result.value)) {
            case RECORDING_CALL_FEATURE: {
                result_object = RecordingCallFeature.getInstance(handle, transfer);
                break;
            }
            case TRANSCRIPTION_CALL_FEATURE: {
                result_object = TranscriptionCallFeature.getInstance(handle, transfer);
                break;
            }
            case CAPTIONS_CALL_FEATURE: {
                result_object = CaptionsCallFeature.getInstance(handle, transfer);
                break;
            }
            case DOMINANT_SPEAKERS_CALL_FEATURE: {
                result_object = DominantSpeakersCallFeature.getInstance(handle, transfer);
                break;
            }
            case RAISE_HAND_CALL_FEATURE: {
                result_object = RaiseHandCallFeature.getInstance(handle, transfer);
                break;
            }
            case SPOTLIGHT_CALL_FEATURE: {
                result_object = SpotlightCallFeature.getInstance(handle, transfer);
                break;
            }
            case LOCAL_USER_DIAGNOSTICS_CALL_FEATURE: {
                result_object = LocalUserDiagnosticsCallFeature.getInstance(handle, transfer);
                break;
            }
            case MEDIA_STATISTICS_CALL_FEATURE: {
                result_object = MediaStatisticsCallFeature.getInstance(handle, transfer);
                break;
            }
            case DATA_CHANNEL_CALL_FEATURE: {
                result_object = DataChannelCallFeature.getInstance(handle, transfer);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return result_object;
    }

    static CallCaptions CallCaptionsFactory(long handle, boolean transfer) {
        TeamsCaptions result_object;
        if (handle == 0L) {
            return null;
        }
        Out<HandleType> result = new Out<HandleType>();
        NativeLibraryHelpers.checkStatus(handle, NativeLibrary.sam_get_handle_type(handle, result));
        switch ((HandleType)((Object)result.value)) {
            case TEAMS_CAPTIONS: {
                result_object = TeamsCaptions.getInstance(handle, transfer);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return result_object;
    }

    static RawVideoFrame RawVideoFrameFactory(long handle, boolean transfer) {
        RawVideoFrameBuffer result_object;
        if (handle == 0L) {
            return null;
        }
        Out<HandleType> result = new Out<HandleType>();
        NativeLibraryHelpers.checkStatus(handle, NativeLibrary.sam_get_handle_type(handle, result));
        switch ((HandleType)((Object)result.value)) {
            case RAW_VIDEO_FRAME_BUFFER: {
                result_object = RawVideoFrameBuffer.getInstance(handle, transfer);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return result_object;
    }

    static OutgoingVideoStream OutgoingVideoStreamFactory(long handle, boolean transfer) {
        OutgoingVideoStream result_object;
        if (handle == 0L) {
            return null;
        }
        Out<HandleType> result = new Out<HandleType>();
        NativeLibraryHelpers.checkStatus(handle, NativeLibrary.sam_get_handle_type(handle, result));
        switch ((HandleType)((Object)result.value)) {
            case LOCAL_VIDEO_STREAM: {
                result_object = LocalVideoStream.getInstance(handle, transfer);
                break;
            }
            case SCREEN_SHARE_OUTGOING_VIDEO_STREAM: {
                result_object = ScreenShareOutgoingVideoStream.getInstance(handle, transfer);
                break;
            }
            case VIRTUAL_OUTGOING_VIDEO_STREAM: {
                result_object = VirtualOutgoingVideoStream.getInstance(handle, transfer);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return result_object;
    }

    static CallVideoStream CallVideoStreamFactory(long handle, boolean transfer) {
        CallVideoStream result_object;
        if (handle == 0L) {
            return null;
        }
        Out<HandleType> result = new Out<HandleType>();
        NativeLibraryHelpers.checkStatus(handle, NativeLibrary.sam_get_handle_type(handle, result));
        switch ((HandleType)((Object)result.value)) {
            case LOCAL_VIDEO_STREAM: {
                result_object = LocalVideoStream.getInstance(handle, transfer);
                break;
            }
            case SCREEN_SHARE_OUTGOING_VIDEO_STREAM: {
                result_object = ScreenShareOutgoingVideoStream.getInstance(handle, transfer);
                break;
            }
            case VIRTUAL_OUTGOING_VIDEO_STREAM: {
                result_object = VirtualOutgoingVideoStream.getInstance(handle, transfer);
                break;
            }
            case RAW_INCOMING_VIDEO_STREAM: {
                result_object = RawIncomingVideoStream.getInstance(handle, transfer);
                break;
            }
            case REMOTE_VIDEO_STREAM: {
                result_object = RemoteVideoStream.getInstance(handle, transfer);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return result_object;
    }

    static RawOutgoingVideoStream RawOutgoingVideoStreamFactory(long handle, boolean transfer) {
        RawOutgoingVideoStream result_object;
        if (handle == 0L) {
            return null;
        }
        Out<HandleType> result = new Out<HandleType>();
        NativeLibraryHelpers.checkStatus(handle, NativeLibrary.sam_get_handle_type(handle, result));
        switch ((HandleType)((Object)result.value)) {
            case SCREEN_SHARE_OUTGOING_VIDEO_STREAM: {
                result_object = ScreenShareOutgoingVideoStream.getInstance(handle, transfer);
                break;
            }
            case VIRTUAL_OUTGOING_VIDEO_STREAM: {
                result_object = VirtualOutgoingVideoStream.getInstance(handle, transfer);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return result_object;
    }

    static IncomingVideoStream IncomingVideoStreamFactory(long handle, boolean transfer) {
        IncomingVideoStream result_object;
        if (handle == 0L) {
            return null;
        }
        Out<HandleType> result = new Out<HandleType>();
        NativeLibraryHelpers.checkStatus(handle, NativeLibrary.sam_get_handle_type(handle, result));
        switch ((HandleType)((Object)result.value)) {
            case RAW_INCOMING_VIDEO_STREAM: {
                result_object = RawIncomingVideoStream.getInstance(handle, transfer);
                break;
            }
            case REMOTE_VIDEO_STREAM: {
                result_object = RemoteVideoStream.getInstance(handle, transfer);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return result_object;
    }

    static RawAudioStreamProperties RawAudioStreamPropertiesFactory(long handle, boolean transfer) {
        RawAudioStreamProperties result_object;
        if (handle == 0L) {
            return null;
        }
        Out<HandleType> result = new Out<HandleType>();
        NativeLibraryHelpers.checkStatus(handle, NativeLibrary.sam_get_handle_type(handle, result));
        switch ((HandleType)((Object)result.value)) {
            case RAW_INCOMING_AUDIO_STREAM_PROPERTIES: {
                result_object = RawIncomingAudioStreamProperties.getInstance(handle, transfer);
                break;
            }
            case RAW_OUTGOING_AUDIO_STREAM_PROPERTIES: {
                result_object = RawOutgoingAudioStreamProperties.getInstance(handle, transfer);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return result_object;
    }

    static RawAudioStreamOptions RawAudioStreamOptionsFactory(long handle, boolean transfer) {
        RawAudioStreamOptions result_object;
        if (handle == 0L) {
            return null;
        }
        Out<HandleType> result = new Out<HandleType>();
        NativeLibraryHelpers.checkStatus(handle, NativeLibrary.sam_get_handle_type(handle, result));
        switch ((HandleType)((Object)result.value)) {
            case RAW_OUTGOING_AUDIO_STREAM_OPTIONS: {
                result_object = RawOutgoingAudioStreamOptions.getInstance(handle, transfer);
                break;
            }
            case RAW_INCOMING_AUDIO_STREAM_OPTIONS: {
                result_object = RawIncomingAudioStreamOptions.getInstance(handle, transfer);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return result_object;
    }

    static OutgoingAudioStream OutgoingAudioStreamFactory(long handle, boolean transfer) {
        OutgoingAudioStream result_object;
        if (handle == 0L) {
            return null;
        }
        Out<HandleType> result = new Out<HandleType>();
        NativeLibraryHelpers.checkStatus(handle, NativeLibrary.sam_get_handle_type(handle, result));
        switch ((HandleType)((Object)result.value)) {
            case LOCAL_OUTGOING_AUDIO_STREAM: {
                result_object = LocalOutgoingAudioStream.getInstance(handle, transfer);
                break;
            }
            case RAW_OUTGOING_AUDIO_STREAM: {
                result_object = RawOutgoingAudioStream.getInstance(handle, transfer);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return result_object;
    }

    static CallAudioStream CallAudioStreamFactory(long handle, boolean transfer) {
        CallAudioStream result_object;
        if (handle == 0L) {
            return null;
        }
        Out<HandleType> result = new Out<HandleType>();
        NativeLibraryHelpers.checkStatus(handle, NativeLibrary.sam_get_handle_type(handle, result));
        switch ((HandleType)((Object)result.value)) {
            case LOCAL_OUTGOING_AUDIO_STREAM: {
                result_object = LocalOutgoingAudioStream.getInstance(handle, transfer);
                break;
            }
            case REMOTE_INCOMING_AUDIO_STREAM: {
                result_object = RemoteIncomingAudioStream.getInstance(handle, transfer);
                break;
            }
            case RAW_INCOMING_AUDIO_STREAM: {
                result_object = RawIncomingAudioStream.getInstance(handle, transfer);
                break;
            }
            case RAW_OUTGOING_AUDIO_STREAM: {
                result_object = RawOutgoingAudioStream.getInstance(handle, transfer);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return result_object;
    }

    static IncomingAudioStream IncomingAudioStreamFactory(long handle, boolean transfer) {
        IncomingAudioStream result_object;
        if (handle == 0L) {
            return null;
        }
        Out<HandleType> result = new Out<HandleType>();
        NativeLibraryHelpers.checkStatus(handle, NativeLibrary.sam_get_handle_type(handle, result));
        switch ((HandleType)((Object)result.value)) {
            case REMOTE_INCOMING_AUDIO_STREAM: {
                result_object = RemoteIncomingAudioStream.getInstance(handle, transfer);
                break;
            }
            case RAW_INCOMING_AUDIO_STREAM: {
                result_object = RawIncomingAudioStream.getInstance(handle, transfer);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return result_object;
    }

    static VideoEffect VideoEffectFactory(long handle, boolean transfer) {
        VideoEffect result_object;
        if (handle == 0L) {
            return null;
        }
        Out<HandleType> result = new Out<HandleType>();
        NativeLibraryHelpers.checkStatus(handle, NativeLibrary.sam_get_handle_type(handle, result));
        switch ((HandleType)((Object)result.value)) {
            case BACKGROUND_BLUR_EFFECT: {
                result_object = BackgroundBlurEffect.getInstance(handle, transfer);
                break;
            }
            case BACKGROUND_REPLACEMENT_EFFECT: {
                result_object = BackgroundReplacementEffect.getInstance(handle, transfer);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return result_object;
    }

    static LocalVideoStreamFeature LocalVideoStreamFeatureFactory(long handle, boolean transfer) {
        LocalVideoEffectsFeature result_object;
        if (handle == 0L) {
            return null;
        }
        Out<HandleType> result = new Out<HandleType>();
        NativeLibraryHelpers.checkStatus(handle, NativeLibrary.sam_get_handle_type(handle, result));
        switch ((HandleType)((Object)result.value)) {
            case LOCAL_VIDEO_EFFECTS_FEATURE: {
                result_object = LocalVideoEffectsFeature.getInstance(handle, transfer);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return result_object;
    }

    static <T> T GetFactoryForClass(long handle, boolean transfer, Class<T> clazz) {
        Object referenceTarget;
        if (clazz == CallOptions.class) {
            referenceTarget = Factories.CallOptionsFactory(handle, transfer);
        } else if (clazz == JoinMeetingLocator.class) {
            referenceTarget = Factories.JoinMeetingLocatorFactory(handle, transfer);
        } else if (clazz == JoinTeamsMeetingLocator.class) {
            referenceTarget = Factories.JoinTeamsMeetingLocatorFactory(handle, transfer);
        } else if (clazz == CommonCallAgent.class) {
            referenceTarget = Factories.CommonCallAgentFactory(handle, transfer);
        } else if (clazz == CommonIncomingCall.class) {
            referenceTarget = Factories.CommonIncomingCallFactory(handle, transfer);
        } else if (clazz == CommonCall.class) {
            referenceTarget = Factories.CommonCallFactory(handle, transfer);
        } else if (clazz == CallFeature.class) {
            referenceTarget = Factories.CallFeatureFactory(handle, transfer);
        } else if (clazz == CallCaptions.class) {
            referenceTarget = Factories.CallCaptionsFactory(handle, transfer);
        } else if (clazz == RawVideoFrame.class) {
            referenceTarget = Factories.RawVideoFrameFactory(handle, transfer);
        } else if (clazz == OutgoingVideoStream.class) {
            referenceTarget = Factories.OutgoingVideoStreamFactory(handle, transfer);
        } else if (clazz == CallVideoStream.class) {
            referenceTarget = Factories.CallVideoStreamFactory(handle, transfer);
        } else if (clazz == RawOutgoingVideoStream.class) {
            referenceTarget = Factories.RawOutgoingVideoStreamFactory(handle, transfer);
        } else if (clazz == IncomingVideoStream.class) {
            referenceTarget = Factories.IncomingVideoStreamFactory(handle, transfer);
        } else if (clazz == RawAudioStreamProperties.class) {
            referenceTarget = Factories.RawAudioStreamPropertiesFactory(handle, transfer);
        } else if (clazz == RawAudioStreamOptions.class) {
            referenceTarget = Factories.RawAudioStreamOptionsFactory(handle, transfer);
        } else if (clazz == OutgoingAudioStream.class) {
            referenceTarget = Factories.OutgoingAudioStreamFactory(handle, transfer);
        } else if (clazz == CallAudioStream.class) {
            referenceTarget = Factories.CallAudioStreamFactory(handle, transfer);
        } else if (clazz == IncomingAudioStream.class) {
            referenceTarget = Factories.IncomingAudioStreamFactory(handle, transfer);
        } else if (clazz == VideoEffect.class) {
            referenceTarget = Factories.VideoEffectFactory(handle, transfer);
        } else if (clazz == LocalVideoStreamFeature.class) {
            referenceTarget = Factories.LocalVideoStreamFeatureFactory(handle, transfer);
        } else {
            throw new IllegalArgumentException();
        }
        return clazz.cast(referenceTarget);
    }
}

