/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import com.azure.android.communication.calling.RemoteParticipant;
import com.azure.android.communication.common.CommunicationIdentifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public final class DominantSpeakersInfo {
    long handle;

    DominantSpeakersInfo(long ahandle, boolean transfer) {
        this.handle = ahandle;
        if (!transfer) {
            NativeLibrary.sam_dominant_speakers_info_addref(ahandle);
        }
        ProjectedObjectCache.add(this, this.handle);
    }

    long getHandle() {
        return this.handle;
    }

    protected void finalize() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_dominant_speakers_info_release(this.handle));
        this.handle = 0L;
    }

    private List<RemoteParticipant> getSpeakersInternal() {
        Out<long[]> result = new Out<long[]>();
        Out<Integer> result_length = new Out<Integer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_dominant_speakers_info_get_speakers_internal(this.handle, result, result_length));
        ArrayList<RemoteParticipant> resultList = new ArrayList<RemoteParticipant>();
        long[] resultArray = (long[])result.value;
        for (int i = 0; i < resultArray.length; ++i) {
            resultList.add(RemoteParticipant.getInstance(resultArray[i], true));
        }
        List<RemoteParticipant> resultImmutable = Collections.unmodifiableList(resultList);
        return resultImmutable;
    }

    public Date getLastUpdatedAt() {
        Out<Long> result = new Out<Long>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_dominant_speakers_info_get_last_updated_at(this.handle, result));
        return (Long)result.value == 0L ? new Date(Long.MAX_VALUE) : new Date((Long)result.value);
    }

    static DominantSpeakersInfo getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.DominantSpeakersInfo, DominantSpeakersInfo.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_dominant_speakers_info_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.DominantSpeakersInfo, DominantSpeakersInfo.class, false);
    }

    public List<CommunicationIdentifier> getSpeakers() {
        List<RemoteParticipant> remoteParticipants = this.getSpeakersInternal();
        ArrayList<CommunicationIdentifier> identifiers = new ArrayList<CommunicationIdentifier>();
        for (RemoteParticipant participant : remoteParticipants) {
            identifiers.add(participant.getIdentifier());
        }
        return identifiers;
    }
}

