/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.DataChannelPriority;
import com.azure.android.communication.calling.DataChannelReliability;
import com.azure.android.communication.calling.IdentifierHelpers;
import com.azure.android.communication.calling.InternalObjectHelpers;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import com.azure.android.communication.calling.Status;
import com.azure.android.communication.common.CommunicationIdentifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class DataChannelSenderOptions {
    long handle;

    DataChannelSenderOptions(long ahandle, boolean transfer) {
        this.handle = ahandle;
        if (!transfer) {
            NativeLibrary.sam_data_channel_sender_options_addref(ahandle);
        }
        ProjectedObjectCache.add(this, this.handle);
    }

    long getHandle() {
        return this.handle;
    }

    public DataChannelSenderOptions() {
        Out<Long> result_handle = new Out<Long>();
        Status resultStatus = NativeLibrary.sam_data_channel_sender_options_create(result_handle);
        this.handle = (Long)result_handle.value;
        NativeLibraryHelpers.checkStatus(this.handle, resultStatus);
        ProjectedObjectCache.add(this, this.handle);
    }

    protected void finalize() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_data_channel_sender_options_release(this.handle));
        this.handle = 0L;
    }

    private int getChannelIdInternal() {
        Out<Integer> result = new Out<Integer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_data_channel_sender_options_get_channel_id_internal(this.handle, result));
        return (Integer)result.value;
    }

    private DataChannelSenderOptions setChannelIdInternal(int value) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_data_channel_sender_options_set_channel_id_internal(this.handle, value));
        return this;
    }

    private int getBitrateInKbpsInternal() {
        Out<Integer> result = new Out<Integer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_data_channel_sender_options_get_bitrate_in_kbps_internal(this.handle, result));
        return (Integer)result.value;
    }

    private DataChannelSenderOptions setBitrateInKbpsInternal(int value) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_data_channel_sender_options_set_bitrate_in_kbps_internal(this.handle, value));
        return this;
    }

    public DataChannelPriority getPriority() {
        Out<DataChannelPriority> result = new Out<DataChannelPriority>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_data_channel_sender_options_get_priority(this.handle, result));
        return (DataChannelPriority)((Object)result.value);
    }

    public DataChannelSenderOptions setPriority(DataChannelPriority value) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_data_channel_sender_options_set_priority(this.handle, value));
        return this;
    }

    public DataChannelReliability getReliability() {
        Out<DataChannelReliability> result = new Out<DataChannelReliability>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_data_channel_sender_options_get_reliability(this.handle, result));
        return (DataChannelReliability)((Object)result.value);
    }

    public DataChannelSenderOptions setReliability(DataChannelReliability value) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_data_channel_sender_options_set_reliability(this.handle, value));
        return this;
    }

    private String[] getParticipantsInternal() {
        Out<String[]> result = new Out<String[]>();
        Out<Integer> result_length = new Out<Integer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_data_channel_sender_options_get_participants_internal(this.handle, result, result_length));
        return (String[])result.value;
    }

    private DataChannelSenderOptions setParticipantsInternal(String[] value) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_data_channel_sender_options_set_participants_internal(this.handle, value, value.length));
        return this;
    }

    static DataChannelSenderOptions getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.DataChannelSenderOptions, DataChannelSenderOptions.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_data_channel_sender_options_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.DataChannelSenderOptions, DataChannelSenderOptions.class, false);
    }

    public Integer getChannelId() {
        return InternalObjectHelpers.extractIntegerObject(() -> this.getChannelIdInternal());
    }

    public DataChannelSenderOptions setChannelId(Integer value) {
        return this.setChannelIdInternal(value != null ? value : 0);
    }

    public Integer getBitrateInKbps() {
        return InternalObjectHelpers.extractIntegerObject(() -> this.getBitrateInKbpsInternal());
    }

    public DataChannelSenderOptions setBitrateInKbps(Integer value) {
        return this.setBitrateInKbpsInternal(value != null ? value : 0);
    }

    public List<CommunicationIdentifier> getParticipants() {
        List<String> participants = Arrays.asList(this.getParticipantsInternal());
        ArrayList<CommunicationIdentifier> identifiers = new ArrayList<CommunicationIdentifier>();
        for (String participant : participants) {
            identifiers.add(IdentifierHelpers.from(participant));
        }
        return identifiers;
    }

    public DataChannelSenderOptions setParticipants(List<CommunicationIdentifier> participants) {
        ArrayList<String> mris = new ArrayList<String>();
        for (CommunicationIdentifier identifier : participants) {
            mris.add(IdentifierHelpers.toMRI(identifier));
        }
        String[] mriArray = new String[mris.size()];
        return this.setParticipantsInternal(mris.toArray(mriArray));
    }
}

