/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.DataChannelMessage;
import com.azure.android.communication.calling.IdentifierHelpers;
import com.azure.android.communication.calling.InternalObjectHelpers;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import com.azure.android.communication.calling.ProjectedObjectEventHandlerCache;
import com.azure.android.communication.calling.PropertyChangedEvent;
import com.azure.android.communication.calling.PropertyChangedListener;
import com.azure.android.communication.common.CommunicationIdentifier;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public final class DataChannelReceiver {
    long handle;
    private List<PropertyChangedListener> OnMessageReceivedListeners = new CopyOnWriteArrayList<PropertyChangedListener>();
    private List<PropertyChangedListener> OnClosedListeners = new CopyOnWriteArrayList<PropertyChangedListener>();

    DataChannelReceiver(long ahandle, boolean transfer) {
        this.handle = ahandle;
        if (!transfer) {
            NativeLibrary.sam_data_channel_receiver_addref(ahandle);
        }
        ProjectedObjectCache.add(this, this.handle);
    }

    DataChannelReceiver(long ahandle, boolean transfer, boolean restoreEventHandlers) {
        this(ahandle, transfer);
        if (restoreEventHandlers) {
            this.restoreEventHandlers();
        }
    }

    long getHandle() {
        return this.handle;
    }

    protected void finalize() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_data_channel_receiver_release(this.handle));
        this.handle = 0L;
    }

    private int getChannelIdInternal() {
        Out<Integer> result = new Out<Integer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_data_channel_receiver_get_channel_id_internal(this.handle, result));
        return (Integer)result.value;
    }

    private String getSenderIdentifierInternal() {
        Out<String> result = new Out<String>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_data_channel_receiver_get_sender_identifier_internal(this.handle, result));
        return (String)result.value;
    }

    private static void OnMessageReceivedStaticHandler(long cookie, long args) {
        DataChannelReceiver instance = DataChannelReceiver.getInstance(cookie);
        if (instance != null) {
            PropertyChangedEvent args_converted = args != 0L ? PropertyChangedEvent.getInstance(args, false) : null;
            for (PropertyChangedListener listener : instance.OnMessageReceivedListeners) {
                listener.onPropertyChanged(args_converted);
            }
        }
    }

    public void addOnMessageReceivedListener(PropertyChangedListener listener) {
        this.OnMessageReceivedListeners.add(listener);
        ProjectedObjectEventHandlerCache.addEventHandler(this, this.getHandle(), "OnMessageReceived", listener);
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_data_channel_receiver_set_on_message_received(this.handle, this.getHandle(), this));
    }

    public void removeOnMessageReceivedListener(PropertyChangedListener listener) {
        this.OnMessageReceivedListeners.remove(listener);
        if (ProjectedObjectEventHandlerCache.removeEventHandler(this, this.getHandle(), "OnMessageReceived", listener)) {
            NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_data_channel_receiver_set_on_message_received(this.handle, 0L, null));
        }
    }

    private static void OnClosedStaticHandler(long cookie, long args) {
        DataChannelReceiver instance = DataChannelReceiver.getInstance(cookie);
        if (instance != null) {
            PropertyChangedEvent args_converted = args != 0L ? PropertyChangedEvent.getInstance(args, false) : null;
            for (PropertyChangedListener listener : instance.OnClosedListeners) {
                listener.onPropertyChanged(args_converted);
            }
        }
    }

    public void addOnClosedListener(PropertyChangedListener listener) {
        this.OnClosedListeners.add(listener);
        ProjectedObjectEventHandlerCache.addEventHandler(this, this.getHandle(), "OnClosed", listener);
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_data_channel_receiver_set_on_closed(this.handle, this.getHandle(), this));
    }

    public void removeOnClosedListener(PropertyChangedListener listener) {
        this.OnClosedListeners.remove(listener);
        if (ProjectedObjectEventHandlerCache.removeEventHandler(this, this.getHandle(), "OnClosed", listener)) {
            NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_data_channel_receiver_set_on_closed(this.handle, 0L, null));
        }
    }

    public DataChannelMessage receiveMessage() {
        Out<Long> result_handle = new Out<Long>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_data_channel_receiver_receive_message(this.handle, result_handle));
        DataChannelMessage result_object = (Long)result_handle.value != 0L ? DataChannelMessage.getInstance((Long)result_handle.value, true) : null;
        return result_object;
    }

    static DataChannelReceiver getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.DataChannelReceiver, DataChannelReceiver.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_data_channel_receiver_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.DataChannelReceiver, DataChannelReceiver.class, false);
    }

    private static DataChannelReceiver getInstance(long cookie) {
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.DataChannelReceiver, DataChannelReceiver.class, false);
    }

    void restoreEventHandlers() {
        for (Object eventListener : ProjectedObjectEventHandlerCache.getEventHandlers(this, this.getHandle(), "OnMessageReceived")) {
            this.addOnMessageReceivedListener((PropertyChangedListener)eventListener);
        }
        for (Object eventListener : ProjectedObjectEventHandlerCache.getEventHandlers(this, this.getHandle(), "OnClosed")) {
            this.addOnClosedListener((PropertyChangedListener)eventListener);
        }
    }

    public Integer getChannelId() {
        return InternalObjectHelpers.extractIntegerObject(() -> this.getChannelIdInternal());
    }

    public CommunicationIdentifier getSenderIdentifier() {
        return IdentifierHelpers.from(this.getSenderIdentifierInternal());
    }
}

