/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.CallFeature;
import com.azure.android.communication.calling.DataChannelReceiverCreatedEvent;
import com.azure.android.communication.calling.DataChannelReceiverCreatedListener;
import com.azure.android.communication.calling.DataChannelSender;
import com.azure.android.communication.calling.DataChannelSenderOptions;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import com.azure.android.communication.calling.ProjectedObjectEventHandlerCache;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public final class DataChannelCallFeature
extends CallFeature {
    private List<DataChannelReceiverCreatedListener> OnReceiverCreatedListeners = new CopyOnWriteArrayList<DataChannelReceiverCreatedListener>();

    DataChannelCallFeature(long ahandle, boolean transfer) {
        super(ahandle, transfer);
    }

    DataChannelCallFeature(long ahandle, boolean transfer, boolean restoreEventHandlers) {
        this(ahandle, transfer);
        if (restoreEventHandlers) {
            this.restoreEventHandlers();
        }
    }

    @Override
    long getHandle() {
        return this.handle;
    }

    private static void OnReceiverCreatedStaticHandler(long cookie, long args) {
        DataChannelCallFeature instance = DataChannelCallFeature.getInstance(cookie);
        if (instance != null) {
            DataChannelReceiverCreatedEvent args_converted = args != 0L ? DataChannelReceiverCreatedEvent.getInstance(args, false) : null;
            for (DataChannelReceiverCreatedListener listener : instance.OnReceiverCreatedListeners) {
                listener.onDataChannelReceiverCreated(args_converted);
            }
        }
    }

    public void addOnReceiverCreatedListener(DataChannelReceiverCreatedListener listener) {
        this.OnReceiverCreatedListeners.add(listener);
        ProjectedObjectEventHandlerCache.addEventHandler(this, this.getHandle(), "OnReceiverCreated", listener);
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_data_channel_call_feature_set_on_receiver_created(this.handle, this.getHandle(), this));
    }

    public void removeOnReceiverCreatedListener(DataChannelReceiverCreatedListener listener) {
        this.OnReceiverCreatedListeners.remove(listener);
        if (ProjectedObjectEventHandlerCache.removeEventHandler(this, this.getHandle(), "OnReceiverCreated", listener)) {
            NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_data_channel_call_feature_set_on_receiver_created(this.handle, 0L, null));
        }
    }

    public DataChannelSender getDataChannelSender(DataChannelSenderOptions options) {
        long options_converted = options != null ? options.getHandle() : 0L;
        Out<Long> result_handle = new Out<Long>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_data_channel_call_feature_get_data_channel_sender(this.handle, options_converted, result_handle));
        DataChannelSender result_object = (Long)result_handle.value != 0L ? DataChannelSender.getInstance((Long)result_handle.value, true) : null;
        return result_object;
    }

    static DataChannelCallFeature getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.DataChannelCallFeature, DataChannelCallFeature.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_call_feature_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.DataChannelCallFeature, DataChannelCallFeature.class, false);
    }

    private static DataChannelCallFeature getInstance(long cookie) {
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.DataChannelCallFeature, DataChannelCallFeature.class, false);
    }

    void restoreEventHandlers() {
        for (Object eventListener : ProjectedObjectEventHandlerCache.getEventHandlers(this, this.getHandle(), "OnReceiverCreated")) {
            this.addOnReceiverCreatedListener((DataChannelReceiverCreatedListener)eventListener);
        }
    }
}

