/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.CallEndReason;
import com.azure.android.communication.calling.CallerInfo;
import com.azure.android.communication.calling.CommunicationCallType;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectEventHandlerCache;
import com.azure.android.communication.calling.PropertyChangedEvent;
import com.azure.android.communication.calling.PropertyChangedListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java9.util.concurrent.CompletableFuture;

public abstract class CommonIncomingCall {
    private static final ExecutorService executor = Executors.newCachedThreadPool();
    long handle;
    private List<PropertyChangedListener> OnCallEndedListeners = new CopyOnWriteArrayList<PropertyChangedListener>();

    CommonIncomingCall(long ahandle, boolean transfer) {
        this.handle = ahandle;
        if (!transfer) {
            NativeLibrary.sam_common_incoming_call_addref(ahandle);
        }
        ProjectedObjectCache.add(this, this.handle);
    }

    CommonIncomingCall(long ahandle, boolean transfer, boolean restoreEventHandlers) {
        this(ahandle, transfer);
        if (restoreEventHandlers) {
            this.restoreEventHandlers();
        }
    }

    long getHandle() {
        return this.handle;
    }

    protected void finalize() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_common_incoming_call_release(this.handle));
        this.handle = 0L;
    }

    public CommunicationCallType getType() {
        Out<CommunicationCallType> result = new Out<CommunicationCallType>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_common_incoming_call_get_type(this.handle, result));
        return (CommunicationCallType)((Object)result.value);
    }

    public CallEndReason getCallEndReason() {
        Out<Long> result_handle = new Out<Long>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_common_incoming_call_get_call_end_reason(this.handle, result_handle));
        CallEndReason result_object = (Long)result_handle.value != 0L ? CallEndReason.getInstance((Long)result_handle.value, true) : null;
        return result_object;
    }

    public CallerInfo getCallerInfo() {
        Out<Long> result_handle = new Out<Long>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_common_incoming_call_get_caller_info(this.handle, result_handle));
        CallerInfo result_object = (Long)result_handle.value != 0L ? CallerInfo.getInstance((Long)result_handle.value, true) : null;
        return result_object;
    }

    public String getId() {
        Out<String> result = new Out<String>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_common_incoming_call_get_id(this.handle, result));
        return (String)result.value;
    }

    public boolean isVideoEnabled() {
        Out<Boolean> result = new Out<Boolean>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_common_incoming_call_get_is_video_enabled(this.handle, result));
        return (Boolean)result.value;
    }

    private static void OnCallEndedStaticHandler(long cookie, long args) {
        CommonIncomingCall instance = CommonIncomingCall.getInstance(cookie);
        if (instance != null) {
            PropertyChangedEvent args_converted = args != 0L ? PropertyChangedEvent.getInstance(args, false) : null;
            for (PropertyChangedListener listener : instance.OnCallEndedListeners) {
                listener.onPropertyChanged(args_converted);
            }
        }
    }

    public void addOnCallEndedListener(PropertyChangedListener listener) {
        this.OnCallEndedListeners.add(listener);
        ProjectedObjectEventHandlerCache.addEventHandler(this, this.getHandle(), "OnCallEnded", listener);
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_common_incoming_call_set_on_call_ended(this.handle, this.getHandle(), this));
    }

    public void removeOnCallEndedListener(PropertyChangedListener listener) {
        this.OnCallEndedListeners.remove(listener);
        if (ProjectedObjectEventHandlerCache.removeEventHandler(this, this.getHandle(), "OnCallEnded", listener)) {
            NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_common_incoming_call_set_on_call_ended(this.handle, 0L, null));
        }
    }

    public CompletableFuture<Void> reject() {
        final long handle = this.handle;
        return CompletableFuture.runAsync((Runnable)new Runnable(){

            @Override
            public void run() {
                NativeLibraryHelpers.checkStatus(handle, NativeLibrary.sam_common_incoming_call_reject(handle));
            }
        }, (Executor)executor);
    }

    private static CommonIncomingCall getInstance(long cookie) {
        return ProjectedObjectCache.getOrCreate(cookie, CommonIncomingCall.class, false);
    }

    void restoreEventHandlers() {
        for (Object eventListener : ProjectedObjectEventHandlerCache.getEventHandlers(this, this.getHandle(), "OnCallEnded")) {
            this.addOnCallEndedListener((PropertyChangedListener)eventListener);
        }
    }
}

