/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.MediaStreamType;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.StreamDirection;
import com.azure.android.communication.calling.VideoStreamSourceType;
import com.azure.android.communication.calling.VideoStreamState;
import com.azure.android.communication.calling.VideoStreamType;

public abstract class CallVideoStream {
    long handle;

    CallVideoStream(long ahandle, boolean transfer) {
        this.handle = ahandle;
        if (!transfer) {
            NativeLibrary.sam_call_video_stream_addref(ahandle);
        }
        ProjectedObjectCache.add(this, this.handle);
    }

    long getHandle() {
        return this.handle;
    }

    protected void finalize() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_video_stream_release(this.handle));
        this.handle = 0L;
    }

    public VideoStreamType getType() {
        Out<VideoStreamType> result = new Out<VideoStreamType>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_video_stream_get_type(this.handle, result));
        return (VideoStreamType)((Object)result.value);
    }

    public VideoStreamSourceType getSourceType() {
        Out<VideoStreamSourceType> result = new Out<VideoStreamSourceType>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_video_stream_get_source_type(this.handle, result));
        return (VideoStreamSourceType)((Object)result.value);
    }

    public VideoStreamState getState() {
        Out<VideoStreamState> result = new Out<VideoStreamState>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_video_stream_get_state(this.handle, result));
        return (VideoStreamState)((Object)result.value);
    }

    public StreamDirection getDirection() {
        Out<StreamDirection> result = new Out<StreamDirection>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_video_stream_get_direction(this.handle, result));
        return (StreamDirection)((Object)result.value);
    }

    @Deprecated
    public MediaStreamType getMediaStreamType() {
        Out<MediaStreamType> result = new Out<MediaStreamType>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_video_stream_get_media_stream_type(this.handle, result));
        return (MediaStreamType)((Object)result.value);
    }

    public int getId() {
        Out<Integer> result = new Out<Integer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_video_stream_get_id(this.handle, result));
        return (Integer)result.value;
    }

    void onBindingCreated(long bindingEventHandle) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_video_stream_on_binding_created(this.handle, bindingEventHandle));
    }

    void onBindingReleased() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_video_stream_on_binding_released(this.handle));
    }

    void onBindingFailed() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_video_stream_on_binding_failed(this.handle));
    }
}

