/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import android.content.Context;
import android.util.Log;
import com.azure.android.communication.calling.CallAgent;
import com.azure.android.communication.calling.CallAgentOptions;
import com.azure.android.communication.calling.CallClientOptions;
import com.azure.android.communication.calling.CallDebugInfo;
import com.azure.android.communication.calling.DeviceManager;
import com.azure.android.communication.calling.InitializationOptions;
import com.azure.android.communication.calling.InternalCallClientEvents;
import com.azure.android.communication.calling.InternalTokenProvider;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import com.azure.android.communication.calling.Status;
import com.azure.android.communication.calling.TeamsCallAgent;
import com.azure.android.communication.calling.VideoOrientationManager;
import com.azure.android.communication.common.CommunicationAccessToken;
import com.azure.android.communication.common.CommunicationTokenCredential;
import com.microsoft.media.RtcPalEnvironment;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java9.util.concurrent.CompletableFuture;
import java9.util.concurrent.CompletionException;
import java9.util.function.Supplier;

public final class CallClient {
    private static final ExecutorService executor = Executors.newCachedThreadPool();
    long handle;

    CallClient(long ahandle, boolean transfer) {
        this.handle = ahandle;
        if (!transfer) {
            NativeLibrary.sam_call_client_addref(ahandle);
        }
        ProjectedObjectCache.add(this, this.handle);
    }

    long getHandle() {
        return this.handle;
    }

    public CallClient() {
        Out<Long> result_handle = new Out<Long>();
        Status resultStatus = NativeLibrary.sam_call_client_create(result_handle);
        this.handle = (Long)result_handle.value;
        NativeLibraryHelpers.checkStatus(this.handle, resultStatus);
        ProjectedObjectCache.add(this, this.handle);
    }

    public CallClient(CallClientOptions options) {
        long options_converted = options != null ? options.getHandle() : 0L;
        Out<Long> result_handle = new Out<Long>();
        Status resultStatus = NativeLibrary.sam_call_client_create_call_client_options_options(options_converted, result_handle);
        this.handle = (Long)result_handle.value;
        NativeLibraryHelpers.checkStatus(this.handle, resultStatus);
        ProjectedObjectCache.add(this, this.handle);
    }

    protected void finalize() {
        VideoOrientationManager.resetDeviceManager();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_client_release(this.handle));
        this.handle = 0L;
    }

    private InitializationOptions getInitializationOptions() {
        Out<Long> result_handle = new Out<Long>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_client_get_initialization_options(this.handle, result_handle));
        InitializationOptions result_object = (Long)result_handle.value != 0L ? InitializationOptions.getInstance((Long)result_handle.value, true) : null;
        return result_object;
    }

    private CallClient setInitializationOptions(InitializationOptions value) {
        long value_converted = value != null ? value.getHandle() : 0L;
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_client_set_initialization_options(this.handle, value_converted));
        return this;
    }

    private InternalCallClientEvents getInternalEventsEmitter() {
        Out<Long> result_handle = new Out<Long>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_client_get_internal_events_emitter(this.handle, result_handle));
        InternalCallClientEvents result_object = (Long)result_handle.value != 0L ? InternalCallClientEvents.getInstance((Long)result_handle.value, true) : null;
        return result_object;
    }

    private CallClient setInternalEventsEmitter(InternalCallClientEvents value) {
        long value_converted = value != null ? value.getHandle() : 0L;
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_client_set_internal_events_emitter(this.handle, value_converted));
        return this;
    }

    public CallDebugInfo getDebugInfo() {
        Out<Long> result_handle = new Out<Long>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_client_get_debug_info(this.handle, result_handle));
        CallDebugInfo result_object = (Long)result_handle.value != 0L ? CallDebugInfo.getInstance((Long)result_handle.value, true) : null;
        return result_object;
    }

    private void disposeInternal() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_client_dispose_internal(this.handle));
    }

    private CompletableFuture<CallAgent> createCallAgentInternal(final InternalTokenProvider tokenProvider, final CallAgentOptions callAgentOptions) {
        final long handle = this.handle;
        return CompletableFuture.supplyAsync((Supplier)new Supplier<CallAgent>(){

            public CallAgent get() {
                long tokenProvider_converted = tokenProvider != null ? tokenProvider.getHandle() : 0L;
                long callAgentOptions_converted = callAgentOptions != null ? callAgentOptions.getHandle() : 0L;
                Out<Long> result_handle = new Out<Long>();
                NativeLibraryHelpers.checkStatus(handle, NativeLibrary.sam_call_client_create_call_agent_internal(handle, tokenProvider_converted, callAgentOptions_converted, result_handle));
                CallAgent result_object = CallAgent.getInstance((Long)result_handle.value, true);
                return result_object;
            }
        }, (Executor)executor);
    }

    private CompletableFuture<TeamsCallAgent> createTeamsCallAgentInternal(final InternalTokenProvider tokenProvider) {
        final long handle = this.handle;
        return CompletableFuture.supplyAsync((Supplier)new Supplier<TeamsCallAgent>(){

            public TeamsCallAgent get() {
                long tokenProvider_converted = tokenProvider != null ? tokenProvider.getHandle() : 0L;
                Out<Long> result_handle = new Out<Long>();
                NativeLibraryHelpers.checkStatus(handle, NativeLibrary.sam_call_client_create_teams_call_agent_internal(handle, tokenProvider_converted, result_handle));
                TeamsCallAgent result_object = TeamsCallAgent.getInstance((Long)result_handle.value, true);
                return result_object;
            }
        }, (Executor)executor);
    }

    private CompletableFuture<DeviceManager> getDeviceManagerInternal() {
        final long handle = this.handle;
        return CompletableFuture.supplyAsync((Supplier)new Supplier<DeviceManager>(){

            public DeviceManager get() {
                Out<Long> result_handle = new Out<Long>();
                NativeLibraryHelpers.checkStatus(handle, NativeLibrary.sam_call_client_get_device_manager_internal(handle, result_handle));
                DeviceManager result_object = DeviceManager.getInstance((Long)result_handle.value, true);
                return result_object;
            }
        }, (Executor)executor);
    }

    static CallClient getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.CallClient, CallClient.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_call_client_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.CallClient, CallClient.class, false);
    }

    public void dispose() {
        VideoOrientationManager.resetDeviceManager();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_client_dispose_internal(this.handle));
    }

    private void setInitializationOptionsIfNotExists(Context context) {
        InitializationOptions initializationOptions = this.getInitializationOptions();
        if (initializationOptions == null) {
            RtcPalEnvironment.setContext((Context)context);
            initializationOptions = new InitializationOptions();
            initializationOptions.setDataPath(context.getFilesDir().getAbsolutePath() + "/dataPath");
            initializationOptions.setLogFileName(context.getFilesDir().getAbsolutePath() + "/acs_sdk.blog");
            this.setInitializationOptions(initializationOptions);
        }
    }

    public CompletableFuture<DeviceManager> getDeviceManager(Context context) {
        this.setInitializationOptionsIfNotExists(context);
        return this.getDeviceManagerInternal();
    }

    public CompletableFuture<CallAgent> createCallAgent(final Context appContext, final CommunicationTokenCredential communicationTokenCredential, final CallAgentOptions callAgentOptions) {
        final CallClient callClient = this;
        return CompletableFuture.supplyAsync((Supplier)new Supplier<CallAgent>(){

            public CallAgent get() {
                InternalTokenProvider internaltokenProvider = new InternalTokenProvider();
                internaltokenProvider.addOnTokenRequestedListener(sender -> {
                    try {
                        String internalSkypeToken = ((CommunicationAccessToken)communicationTokenCredential.getToken().get()).getToken();
                        sender.parseToken(internalSkypeToken);
                        if (!sender.checkTokenScope()) {
                            sender.setError("AccessToken does not contain 'voip' or 'voip.join' scope");
                        }
                    }
                    catch (Exception e) {
                        sender.setError("Failed to fetch token:" + e.getMessage());
                    }
                });
                CallAgent agent = null;
                try {
                    CallClient.this.setInitializationOptionsIfNotExists(appContext);
                    agent = (CallAgent)callClient.createCallAgentInternal(internaltokenProvider, callAgentOptions).get();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    throw new CompletionException((Throwable)e);
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                    throw new CompletionException((Throwable)e);
                }
                if (agent != null) {
                    CompletableFuture<DeviceManager> dmCompletableFuture = CallClient.this.getDeviceManager(appContext);
                    Executors.newCachedThreadPool().submit(() -> {
                        try {
                            VideoOrientationManager.getInstance(appContext).setDeviceManager((DeviceManager)dmCompletableFuture.get());
                        }
                        catch (InterruptedException | ExecutionException exception) {
                            // empty catch block
                        }
                    });
                }
                return agent;
            }
        }, (Executor)Executors.newCachedThreadPool());
    }

    public CompletableFuture<CallAgent> createCallAgent(Context appContext, CommunicationTokenCredential communicationTokenCredential) {
        return this.createCallAgent(appContext, communicationTokenCredential, null);
    }

    public CompletableFuture<TeamsCallAgent> createTeamsCallAgent(final Context appContext, final CommunicationTokenCredential communicationTokenCredential) {
        final CallClient callClient = this;
        return CompletableFuture.supplyAsync((Supplier)new Supplier<TeamsCallAgent>(){

            public TeamsCallAgent get() {
                InternalTokenProvider internaltokenProvider = new InternalTokenProvider();
                internaltokenProvider.addOnTokenRequestedListener(sender -> {
                    try {
                        String internalSkypeToken = ((CommunicationAccessToken)communicationTokenCredential.getToken().get()).getToken();
                        sender.parseToken(internalSkypeToken);
                    }
                    catch (Exception e) {
                        sender.setError("Failed to fetch token:" + e.getMessage());
                    }
                });
                TeamsCallAgent agent = null;
                try {
                    CallClient.this.setInitializationOptionsIfNotExists(appContext);
                    agent = (TeamsCallAgent)callClient.createTeamsCallAgentInternal(internaltokenProvider).get();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    throw new CompletionException((Throwable)e);
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                    throw new CompletionException((Throwable)e);
                }
                if (agent != null) {
                    CompletableFuture<DeviceManager> dmCompletableFuture = CallClient.this.getDeviceManager(appContext);
                    Executors.newCachedThreadPool().submit(() -> {
                        try {
                            VideoOrientationManager.getInstance(appContext).setDeviceManager((DeviceManager)dmCompletableFuture.get());
                        }
                        catch (InterruptedException | ExecutionException exception) {
                            // empty catch block
                        }
                    });
                }
                return agent;
            }
        }, (Executor)Executors.newCachedThreadPool());
    }

    static void loadNativeLibraries() {
        String[] nativeLibsToLoad;
        for (String nativeLib : nativeLibsToLoad = new String[]{"c++_shared", "skypert", "RtmMediaManagerDyn", "ACSCallingShared"}) {
            try {
                System.loadLibrary(nativeLib);
            }
            catch (UnsatisfiedLinkError ex) {
                Log.e((String)"CallClient", (String)String.format("Native library %s failed to load during initialization.\n%s", nativeLib, ex));
                throw ex;
            }
        }
    }

    static {
        CallClient.loadNativeLibraries();
    }
}

