/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import com.azure.android.communication.calling.Status;
import com.azure.android.communication.calling.VideoEffect;
import java.nio.ByteBuffer;

public final class BackgroundReplacementEffect
extends VideoEffect {
    BackgroundReplacementEffect(long ahandle, boolean transfer) {
        super(ahandle, transfer);
    }

    @Override
    long getHandle() {
        return this.handle;
    }

    static long Create() {
        Out<Long> result_handle = new Out<Long>();
        Status resultStatus = NativeLibrary.sam_background_replacement_effect_create(result_handle);
        NativeLibraryHelpers.checkStatus((Long)result_handle.value, resultStatus);
        return (Long)result_handle.value;
    }

    public BackgroundReplacementEffect() {
        super(BackgroundReplacementEffect.Create(), true);
    }

    public ByteBuffer getBuffer() {
        Out<ByteBuffer> result = new Out<ByteBuffer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_background_replacement_effect_get_buffer(this.handle, result));
        return (ByteBuffer)result.value;
    }

    public BackgroundReplacementEffect setBuffer(ByteBuffer value) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_background_replacement_effect_set_buffer(this.handle, value));
        return this;
    }

    static BackgroundReplacementEffect getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.BackgroundReplacementEffect, BackgroundReplacementEffect.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_video_effect_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.BackgroundReplacementEffect, BackgroundReplacementEffect.class, false);
    }
}

