/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.dl.utils;

import com.microsoft.dl.BuildInfo;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;

public final class Log {
    public static final int DEBUG = 3;
    public static final int INFO = 4;
    public static final int WARN = 5;
    public static final int ERROR = 6;
    public static final int ASSERT = 7;
    private static final int CALL_STACK_LEVEL = 4;
    private static final StackTraceElement UNKNOWN_STACK_TRACE_ELEMENT = new StackTraceElement("<unknown>", "<unknown>", "<unknown>", 0);
    private static final StackTraceElement EMPTY_STACK_TRACE_ELEMENT = new StackTraceElement("", "", "", 0);
    private static final boolean IS_VERBOSE = BuildInfo.FLAVOUR == BuildInfo.Flavour.DEBUG;
    private static boolean isLogLevelSet = false;
    private static int minLogLevel = 4;

    public static void d(String tag, String msg) {
        StackTraceElement ste = IS_VERBOSE ? Log.getStackTrace() : EMPTY_STACK_TRACE_ELEMENT;
        Log.safeLog(tag, 3, ste.getFileName(), ste.getClassName(), ste.getMethodName(), ste.getLineNumber(), msg, null, null);
    }

    public static void d(String tag, String msg, Throwable t) {
        StackTraceElement ste = IS_VERBOSE ? Log.getStackTrace() : EMPTY_STACK_TRACE_ELEMENT;
        Log.safeLog(tag, 3, ste.getFileName(), ste.getClassName(), ste.getMethodName(), ste.getLineNumber(), msg, Log.getStackTraceString(t), null);
    }

    public static void i(String tag, String msg) {
        StackTraceElement ste = IS_VERBOSE ? Log.getStackTrace() : EMPTY_STACK_TRACE_ELEMENT;
        Log.safeLog(tag, 4, ste.getFileName(), ste.getClassName(), ste.getMethodName(), ste.getLineNumber(), msg, null, null);
    }

    public static void i(String tag, String msg, Throwable t) {
        StackTraceElement ste = IS_VERBOSE ? Log.getStackTrace() : EMPTY_STACK_TRACE_ELEMENT;
        Log.safeLog(tag, 4, ste.getFileName(), ste.getClassName(), ste.getMethodName(), ste.getLineNumber(), msg, Log.getStackTraceString(t), null);
    }

    public static void w(String tag, String msg) {
        StackTraceElement ste = IS_VERBOSE ? Log.getStackTrace() : EMPTY_STACK_TRACE_ELEMENT;
        Log.safeLog(tag, 5, ste.getFileName(), ste.getClassName(), ste.getMethodName(), ste.getLineNumber(), msg, null, null);
    }

    public static void w(String tag, String msg, Throwable t) {
        StackTraceElement ste = IS_VERBOSE ? Log.getStackTrace() : EMPTY_STACK_TRACE_ELEMENT;
        Log.safeLog(tag, 5, ste.getFileName(), ste.getClassName(), ste.getMethodName(), ste.getLineNumber(), msg, Log.getStackTraceString(t), null);
    }

    public static void e(String tag, String msg) {
        StackTraceElement ste = IS_VERBOSE ? Log.getStackTrace() : EMPTY_STACK_TRACE_ELEMENT;
        Log.safeLog(tag, 6, ste.getFileName(), ste.getClassName(), ste.getMethodName(), ste.getLineNumber(), msg, null, null);
    }

    public static void e(String tag, String msg, Throwable t) {
        StackTraceElement ste = IS_VERBOSE ? Log.getStackTrace() : EMPTY_STACK_TRACE_ELEMENT;
        Log.safeLog(tag, 6, ste.getFileName(), ste.getClassName(), ste.getMethodName(), ste.getLineNumber(), msg, Log.getStackTraceString(t), null);
    }

    public static void a(String tag, String msg) {
        StackTraceElement ste = IS_VERBOSE ? Log.getStackTrace() : EMPTY_STACK_TRACE_ELEMENT;
        Log.safeLog(tag, 7, ste.getFileName(), ste.getClassName(), ste.getMethodName(), ste.getLineNumber(), msg, null, Log.getStackTraceString());
    }

    public static void a(String tag, String msg, Throwable t) {
        StackTraceElement ste = IS_VERBOSE ? Log.getStackTrace() : EMPTY_STACK_TRACE_ELEMENT;
        Log.safeLog(tag, 7, ste.getFileName(), ste.getClassName(), ste.getMethodName(), ste.getLineNumber(), msg, Log.getStackTraceString(t), Log.getStackTraceString());
    }

    public static boolean isLoggable(String tag, int level) {
        try {
            if (!isLogLevelSet) {
                minLogLevel = Log.getMinLoggingLevel();
                isLogLevelSet = true;
            }
            return minLogLevel >= 0 && level >= minLogLevel;
        }
        catch (UnsatisfiedLinkError e) {
            return false;
        }
    }

    public static void refreshMinLogLevelIfNeed() {
        if (isLogLevelSet) {
            minLogLevel = Log.getMinLoggingLevel();
        }
    }

    public static void log(int level, String tag, String msg) {
        if (Log.isLoggable(tag, level)) {
            StackTraceElement ste = IS_VERBOSE ? Log.getStackTrace() : EMPTY_STACK_TRACE_ELEMENT;
            Log.safeLog(tag, level, ste.getFileName(), ste.getClassName(), ste.getMethodName(), ste.getLineNumber(), msg, null, null);
        }
    }

    public static void log(int level, String tag, String msg, Throwable t) {
        if (Log.isLoggable(tag, level)) {
            StackTraceElement ste = IS_VERBOSE ? Log.getStackTrace() : EMPTY_STACK_TRACE_ELEMENT;
            Log.safeLog(tag, level, ste.getFileName(), ste.getClassName(), ste.getMethodName(), ste.getLineNumber(), msg, Log.getStackTraceString(t), null);
        }
    }

    private static void safeLog(String tag, int level, String fileName, String className, String methodName, int lineNum, String msg, String exception, String callStack) {
        try {
            Log.log(tag, level, fileName, className, methodName, lineNum, msg, exception, callStack);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
    }

    private static String getStackTraceString(Throwable t) {
        StringWriter writer = new StringWriter();
        try {
            ((Writer)writer).append(t.toString());
            ((Writer)writer).append("\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        t.printStackTrace(new PrintWriter(writer));
        return ((Object)writer).toString();
    }

    private static StackTraceElement getStackTrace() {
        StackTraceElement[] stackDump = Thread.currentThread().getStackTrace();
        if (stackDump != null && stackDump.length > 4) {
            return stackDump[4];
        }
        return UNKNOWN_STACK_TRACE_ELEMENT;
    }

    private static String getStackTraceString() {
        StringBuilder str = new StringBuilder();
        StackTraceElement[] stackDump = Thread.currentThread().getStackTrace();
        for (int i = 4; i < stackDump.length; ++i) {
            StackTraceElement ste = stackDump[i];
            if (str.length() > 0) {
                str.append('\n');
            }
            str.append("\t");
            str.append(ste.getClassName());
            str.append('.');
            str.append(ste.getMethodName());
            str.append('(');
            if (ste.isNativeMethod()) {
                str.append("Native method");
            } else {
                str.append(ste.getFileName());
                str.append(':');
                if (ste.getLineNumber() > 0) {
                    str.append(ste.getLineNumber());
                } else {
                    str.append("?");
                }
            }
            str.append(')');
        }
        return str.toString();
    }

    private static native void log(String var0, int var1, String var2, String var3, String var4, int var5, String var6, String var7, String var8);

    private static native int getMinLoggingLevel();
}

