/*
 * Decompiled with CFR 0.152.
 */
package com.skype.android.video.render.pipeline;

import android.view.Surface;
import com.skype.android.util2.Log;
import com.skype.android.video.render.BindingRenderer;
import com.skype.android.video.render.CapturedFrame;

public class RenderController {
    private static String TAG = RenderController.class.getSimpleName();
    private long nativePtr;
    private BindingRenderer.Callback callback;

    public RenderController(BindingRenderer.Callback callback, long renderInterval, long nativeTestHooksPtr) {
        if (Log.isLoggable(TAG, 4)) {
            Log.i(TAG, "+RenderController, callback: " + callback);
        }
        this.callback = callback;
        this.nativeInit(renderInterval, nativeTestHooksPtr);
    }

    public native void setSurface(Surface var1, int var2, int var3);

    public native void setViewSize(int var1, int var2);

    public native int getNativeBindingType();

    public native long getNativeBindingEvent();

    public native boolean resume();

    public native boolean pause();

    public native CapturedFrame nativeCaptureFrame();

    private native void nativeInit(long var1, long var3);

    private native void nativeUninit();

    private native void enablePipelineEventReport(boolean var1);

    private void onBindingCreated(long bindingRef) {
        if (Log.isLoggable(TAG, 4)) {
            Log.i(TAG, "RenderController.onBindingCreated, bindingRef: " + bindingRef);
        }
        if (this.callback != null) {
            this.callback.onBindingCreated(bindingRef);
        }
    }

    private void onBindingReleased() {
        if (Log.isLoggable(TAG, 4)) {
            Log.i(TAG, "RenderController.onBindingReleased");
        }
        if (this.callback != null) {
            this.callback.onBindingReleased();
        }
    }

    private void onBindingFailed() {
        if (Log.isLoggable(TAG, 4)) {
            Log.i(TAG, "RenderController.onBindingFailed");
        }
        if (this.callback != null) {
            this.callback.onBindingFailed();
        }
    }

    private void onFirstFrameRendered() {
        if (Log.isLoggable(TAG, 4)) {
            Log.i(TAG, "RenderController.onFirstFrameRendered");
        }
        if (this.callback != null) {
            this.callback.onFirstFrameRendered();
        }
    }

    private void onFrameSizeChanged(int width, int height) {
        if (Log.isLoggable(TAG, 4)) {
            Log.i(TAG, "RenderController.onFrameSizeChanged, width: " + width + ", height: " + height);
        }
        if (this.callback != null) {
            this.callback.onSizeChanged(width, height);
        }
    }

    private void onRoiChanged(float leftOffset, float topOffset, float width, float height) {
        if (Log.isLoggable(TAG, 4)) {
            Log.i(TAG, "RenderController.onRoiChanged, width: " + width + ", height: " + height + ", left: " + leftOffset + ", top: " + topOffset);
        }
        if (this.callback != null) {
            this.callback.onRoiChanged(leftOffset, topOffset, width, height);
        }
    }

    public void dispose() {
        if (Log.isLoggable(TAG, 4)) {
            Log.i(TAG, "RenderController.dispose");
        }
        this.nativeUninit();
    }
}

