/*
 * Decompiled with CFR 0.152.
 */
package com.skype.android.video.render.pipeline;

import android.graphics.Bitmap;
import android.graphics.SurfaceTexture;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.TextureView;
import com.skype.android.util2.Log;
import com.skype.android.video.render.BindingRenderer;
import com.skype.android.video.render.CapturedFrame;
import com.skype.android.video.render.GLTextureView;
import com.skype.android.video.render.pipeline.RenderController;

public class BindingRendererAdapter
implements BindingRenderer,
TextureView.SurfaceTextureListener,
SurfaceHolder.Callback {
    private static String TAG = BindingRendererAdapter.class.getSimpleName();
    private RenderController _controller;
    private GLTextureView _textureView;
    private SurfaceView _surfaceView;

    public BindingRendererAdapter(BindingRenderer.Callback cb, long renderInterval, long nativeTestHooksPtr) {
        if (Log.isLoggable(TAG, 4)) {
            Log.i(TAG, "+BindingRendererAdapter");
        }
        this._controller = new RenderController(cb, renderInterval, nativeTestHooksPtr);
    }

    public void registerView(Object view) {
        if (Log.isLoggable(TAG, 4)) {
            Log.i(TAG, "BindingRendererAdapter.registerView: " + view);
        }
        if (view == null) {
            throw new NullPointerException("view is null");
        }
        if (view instanceof GLTextureView) {
            this._textureView = (GLTextureView)((Object)view);
            this._textureView.setSurfaceTextureListener(this);
        } else if (view instanceof SurfaceView) {
            this._surfaceView = (SurfaceView)view;
            this._surfaceView.getHolder().addCallback((SurfaceHolder.Callback)this);
        } else {
            throw new ClassCastException("view is not of correct type");
        }
    }

    public void unregisterView(Object view) {
        if (Log.isLoggable(TAG, 4)) {
            Log.i(TAG, "BindingRendererAdapter.unregisterView: " + view);
        }
        if (this._textureView != null) {
            this._textureView.setSurfaceTextureListener(null);
            this._textureView = null;
        } else if (this._surfaceView != null) {
            this._surfaceView.getHolder().removeCallback((SurfaceHolder.Callback)this);
            this._surfaceView = null;
        }
        this._controller.pause();
    }

    public Bitmap captureFrame() {
        CapturedFrame frame = this.captureFrame2();
        if (frame != null) {
            return frame.bitmap;
        }
        return null;
    }

    public CapturedFrame captureFrame2() {
        return this._controller.nativeCaptureFrame();
    }

    public void dispose() {
        if (Log.isLoggable(TAG, 4)) {
            Log.i(TAG, "BindingRendererAdapter.dispose");
        }
        this._controller.dispose();
        this._controller = null;
    }

    public int getNativeBindingType() {
        if (Log.isLoggable(TAG, 4)) {
            Log.i(TAG, "BindingRendererAdapter.getNativeBindingType");
        }
        return this._controller.getNativeBindingType();
    }

    public long getNativeBindingEvent() {
        if (Log.isLoggable(TAG, 4)) {
            Log.i(TAG, "BindingRendererAdapter.getNativeBindingEvent");
        }
        return this._controller.getNativeBindingEvent();
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
        if (Log.isLoggable(TAG, 4)) {
            Log.i(TAG, "BindingRendererAdapter.onSurfaceTextureAvailable, st: " + surface + ", width: " + width + ", height: " + height);
        }
        if (this._controller != null) {
            this._controller.setSurface(new Surface(surface), width, height);
            this._controller.resume();
        } else if (Log.isLoggable(TAG, 6)) {
            Log.e(TAG, "BindingRendererAdapter.onSurfaceTextureAvailable after dispose call");
        }
        if (this._textureView != null) {
            this._textureView.onSurfaceTextureAvailable(surface, width, height);
        }
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
        if (Log.isLoggable(TAG, 4)) {
            Log.i(TAG, "BindingRendererAdapter.onSurfaceTextureSizeChanged, st: " + surface + ", width: " + width + ", height: " + height);
        }
        if (this._controller != null) {
            this._controller.setViewSize(width, height);
        } else if (Log.isLoggable(TAG, 6)) {
            Log.e(TAG, "BindingRendererAdapter.onSurfaceTextureSizeChanged after dispose call");
        }
        if (this._textureView != null) {
            this._textureView.onSurfaceTextureSizeChanged(surface, width, height);
        }
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
        if (Log.isLoggable(TAG, 4)) {
            Log.i(TAG, "BindingRendererAdapter.onSurfaceTextureDestroyed, st: " + surface);
        }
        if (this._controller != null) {
            this._controller.pause();
            this._controller.setSurface(null, 0, 0);
        } else if (Log.isLoggable(TAG, 5)) {
            Log.w(TAG, "BindingRendererAdapter.onSurfaceTextureDestroyed after dispose call");
        }
        if (this._textureView != null) {
            return this._textureView.onSurfaceTextureDestroyed(surface);
        }
        return true;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surface) {
        if (this._textureView != null) {
            this._textureView.onSurfaceTextureUpdated(surface);
        }
    }

    public void surfaceCreated(SurfaceHolder holder) {
        if (Log.isLoggable(TAG, 4)) {
            Log.i(TAG, "BindingRendererAdapter.surfaceCreated, holder: " + holder);
        }
        if (this._controller != null) {
            this._controller.setSurface(holder.getSurface(), this._surfaceView.getWidth(), this._surfaceView.getHeight());
            this._controller.resume();
        }
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        if (Log.isLoggable(TAG, 4)) {
            Log.i(TAG, "BindingRendererAdapter.surfaceChanged, holder: " + holder + ", width: " + width + ", height: " + height);
        }
        if (this._controller != null) {
            this._controller.setSurface(holder.getSurface(), width, height);
            this._controller.setViewSize(width, height);
        }
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        if (Log.isLoggable(TAG, 4)) {
            Log.i(TAG, "BindingRendererAdapter.surfaceDestroyed, holder: " + holder);
        }
        if (this._controller != null) {
            this._controller.pause();
            this._controller.setSurface(null, 0, 0);
        }
    }
}

