/*
 * Decompiled with CFR 0.152.
 */
package com.skype.android.video.render;

import android.graphics.Bitmap;
import com.skype.android.util2.Log;
import com.skype.android.video.render.BindingRenderer;
import com.skype.android.video.render.CapturedFrame;
import com.skype.android.video.render.GLTextureView;
import com.skype.android.video.render.legacy.LegacyGLESBindingRenderer;
import com.skype.android.video.render.pipeline.BindingRendererAdapter;

public class GLESBindingRenderer
implements BindingRenderer {
    private final String TAG;
    private final String SIMPLE_CLASS_NAME = this.getClass().getSimpleName();
    private final LegacyGLESBindingRenderer mLegacyRenderer;
    private final BindingRendererAdapter mAdapter;

    public GLESBindingRenderer(BindingRenderer.Callback cb) {
        this(cb, 0L);
    }

    private GLESBindingRenderer(BindingRenderer.Callback cb, long nativeTestHooksPtr) {
        this.TAG = "" + System.identityHashCode(this);
        if (Log.isLoggable(this.TAG, 3)) {
            Log.d(this.TAG, this.SIMPLE_CLASS_NAME + '#' + "GLESBindingRenderer() called.");
        }
        if (LegacyGLESBindingRenderer.isRenderPipelineEnabled()) {
            this.mAdapter = new BindingRendererAdapter(cb, LegacyGLESBindingRenderer.getRenderInterval(), nativeTestHooksPtr);
            this.mLegacyRenderer = null;
        } else {
            this.mLegacyRenderer = new LegacyGLESBindingRenderer(cb);
            this.mAdapter = null;
        }
    }

    public static boolean isSurfaceViewSupported() {
        return LegacyGLESBindingRenderer.isRenderPipelineEnabled();
    }

    public void checkView(Object view) {
        if (view == null) {
            throw new NullPointerException("view is null");
        }
        if (!(view instanceof GLTextureView)) {
            throw new ClassCastException("view is not of correct type");
        }
    }

    public int getFramesRendered() {
        if (this.mLegacyRenderer != null) {
            return this.mLegacyRenderer.getFramesRendered();
        }
        return 0;
    }

    public void registerView(Object view) {
        if (Log.isLoggable(this.TAG, 3)) {
            Log.d(this.TAG, this.SIMPLE_CLASS_NAME + '#' + "registerView() called. view=" + view);
        }
        if (this.mLegacyRenderer != null) {
            this.checkView(view);
            GLTextureView textureView = (GLTextureView)((Object)view);
            this.mLegacyRenderer.registerView(textureView.getLegacyView());
        } else if (this.mAdapter != null) {
            this.mAdapter.registerView(view);
        }
    }

    public void unregisterView(Object view) {
        if (Log.isLoggable(this.TAG, 3)) {
            Log.d(this.TAG, this.SIMPLE_CLASS_NAME + '#' + "unregisterView() called. view=" + view);
        }
        if (this.mLegacyRenderer != null) {
            this.checkView(view);
            GLTextureView textureView = (GLTextureView)((Object)view);
            this.mLegacyRenderer.unregisterView(textureView.getLegacyView());
        } else if (this.mAdapter != null) {
            this.mAdapter.unregisterView(view);
        }
    }

    public Bitmap captureFrame() {
        if (this.mLegacyRenderer != null) {
            return this.mLegacyRenderer.captureFrame();
        }
        if (this.mAdapter != null) {
            return this.mAdapter.captureFrame();
        }
        return null;
    }

    public CapturedFrame captureFrame2() {
        if (this.mLegacyRenderer != null) {
            return this.mLegacyRenderer.captureFrame2();
        }
        if (this.mAdapter != null) {
            return this.mAdapter.captureFrame2();
        }
        return null;
    }

    public void dispose() {
        if (Log.isLoggable(this.TAG, 3)) {
            Log.d(this.TAG, this.SIMPLE_CLASS_NAME + '#' + "dispose() called.");
        }
        if (this.mLegacyRenderer != null) {
            this.mLegacyRenderer.dispose();
        } else if (this.mAdapter != null) {
            this.mAdapter.dispose();
        }
    }

    public int getNativeBindingType() {
        if (this.mLegacyRenderer != null) {
            return this.mLegacyRenderer.getNativeBindingType();
        }
        if (this.mAdapter != null) {
            return this.mAdapter.getNativeBindingType();
        }
        return 0;
    }

    public long getNativeBindingEvent() {
        if (this.mLegacyRenderer != null) {
            return this.mLegacyRenderer.getNativeBindingEvent();
        }
        if (this.mAdapter != null) {
            return this.mAdapter.getNativeBindingEvent();
        }
        return 0L;
    }
}

