/*
 * Decompiled with CFR 0.152.
 */
package com.skype.android.video.capture;

import android.graphics.SurfaceTexture;
import android.os.Handler;
import com.skype.android.video.capture.IPreviewBinding;
import com.skype.android.video.capture.PreviewBinding;
import java.util.LinkedList;
import java.util.Queue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UiPreviewBinding
implements IPreviewBinding.Callback {
    private final Handler handler;
    private final Callback cb;
    private PreviewBinding previewBinding;
    private boolean isStarted = false;
    private boolean isStopped = false;
    private boolean canUsePreviewBinding = false;
    private boolean isBindingCallbackActive = false;
    private SurfaceTexture mostRecentSurface;
    private Queue<SurfaceTexture> unsetSurfacesWaitingToBeNotified = new LinkedList<SurfaceTexture>();
    private Queue<SurfaceTexture> surfacesToUnsetNext = new LinkedList<SurfaceTexture>();

    public UiPreviewBinding(Handler handler, Callback cb) {
        this.handler = handler;
        this.cb = cb;
    }

    public BindingParams setup() {
        if (this.isStarted) {
            throw new IllegalStateException("can not setup twice");
        }
        this.isStarted = true;
        this.previewBinding = new PreviewBinding(this);
        return this.getBindingParams(this.previewBinding);
    }

    public BindingParams destroy() {
        if (!this.isStarted || this.isStopped) {
            throw new IllegalStateException("can not destroy twice or before setup");
        }
        this.isStopped = true;
        this.canUsePreviewBinding = false;
        return this.getBindingParams(this.previewBinding);
    }

    public void setSurface(SurfaceTexture surface) {
        this.notifyOnPreviewSurfaceUnset(this.unsetSurfacesWaitingToBeNotified);
        if (this.mostRecentSurface != null) {
            this.surfacesToUnsetNext.add(this.mostRecentSurface);
        }
        this.mostRecentSurface = surface;
        if (this.canUsePreviewBinding) {
            this.previewBinding.setPreviewSurface(surface);
        } else if (!this.isBindingCallbackActive) {
            this.notifyOnPreviewSurfaceUnset(this.surfacesToUnsetNext);
        }
    }

    private void notifyOnPreviewSurfaceUnset(Queue<SurfaceTexture> surfaces) {
        while (!surfaces.isEmpty()) {
            this.cb.onPreviewSurfaceUnset(surfaces.remove());
        }
    }

    private BindingParams getBindingParams(PreviewBinding pb) {
        BindingParams params = new BindingParams();
        params.type = pb.getNativeBindingType();
        params.event = pb.getNativeBindingEvent();
        return params;
    }

    @Override
    public void onBindingCreated(long binding) {
        this.handler.post(new Runnable(){

            public void run() {
                UiPreviewBinding.this.canUsePreviewBinding = UiPreviewBinding.this.isStarted && !UiPreviewBinding.this.isStopped;
                if (UiPreviewBinding.this.canUsePreviewBinding) {
                    UiPreviewBinding.this.isBindingCallbackActive = true;
                    if (UiPreviewBinding.this.mostRecentSurface != null) {
                        UiPreviewBinding.this.previewBinding.setPreviewSurface(UiPreviewBinding.this.mostRecentSurface);
                    }
                }
            }
        });
    }

    @Override
    public void onBindingReleased() {
        this.previewBinding.dispose();
        this.handler.post(new Runnable(){

            public void run() {
                UiPreviewBinding.this.isBindingCallbackActive = false;
            }
        });
    }

    @Override
    public void onBindingFailed() {
        this.previewBinding.dispose();
        this.handler.post(new Runnable(){

            public void run() {
                UiPreviewBinding.this.cb.onBindingFailed();
            }
        });
    }

    @Override
    public void onFrameSizeChanged(Object holder, final int width, final int height) {
        final SurfaceTexture surface = (SurfaceTexture)holder;
        this.handler.post(new Runnable(){

            public void run() {
                if (UiPreviewBinding.this.mostRecentSurface == surface) {
                    UiPreviewBinding.this.cb.onFrameSizeChanged(surface, width, height);
                }
            }
        });
    }

    @Override
    public void onPreviewSurfaceUnset(Object holder) {
        final SurfaceTexture surface = (SurfaceTexture)holder;
        this.handler.post(new Runnable(){

            public void run() {
                if (UiPreviewBinding.this.surfacesToUnsetNext.remove(surface)) {
                    UiPreviewBinding.this.cb.onPreviewSurfaceUnset(surface);
                } else {
                    UiPreviewBinding.this.unsetSurfacesWaitingToBeNotified.add(surface);
                }
            }
        });
    }

    public static interface Callback {
        public void onFrameSizeChanged(SurfaceTexture var1, int var2, int var3);

        public void onPreviewSurfaceUnset(SurfaceTexture var1);

        public void onBindingFailed();
    }

    public class BindingParams {
        public int type;
        public long event;
    }
}

