/*
 * Decompiled with CFR 0.152.
 */
package com.skype.rt;

import android.os.Build;
import android.security.keystore.KeyGenParameterSpec;
import android.util.Log;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;

public class KeyStoreWrap {
    private static final String TAG = "KSW: ";
    private String m_id = null;
    private static final String m_alias = "a75f3e4c";

    public String id() {
        if (this.m_id != null) {
            return this.m_id;
        }
        if (Build.VERSION.SDK_INT < 23) {
            return null;
        }
        if (!this.encrypt() && !this.createAndStoreKey()) {
            return null;
        }
        if (!this.encrypt()) {
            return null;
        }
        return this.m_id;
    }

    private boolean createAndStoreKey() {
        try {
            KeyStore ks = KeyStore.getInstance("AndroidKeyStore");
            ks.load(null);
            if (ks.containsAlias(m_alias)) {
                return true;
            }
            KeyGenParameterSpec.Builder builder = new KeyGenParameterSpec.Builder(m_alias, 1);
            KeyGenParameterSpec keySpec = builder.setKeySize(128).setBlockModes(new String[]{"ECB"}).setEncryptionPaddings(new String[]{"NoPadding"}).setRandomizedEncryptionRequired(false).build();
            KeyGenerator kg = KeyGenerator.getInstance("AES", "AndroidKeyStore");
            kg.init((AlgorithmParameterSpec)keySpec);
            kg.generateKey();
            return true;
        }
        catch (KeyStoreException e) {
            Log.v((String)TAG, (String)"keystore issues");
        }
        catch (NoSuchAlgorithmException e) {
            Log.v((String)TAG, (String)"algo not supported");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private boolean encrypt() {
        try {
            KeyStore ks = KeyStore.getInstance("AndroidKeyStore");
            ks.load(null);
            if (!ks.containsAlias(m_alias)) {
                return false;
            }
            SecretKey key = (SecretKey)ks.getKey(m_alias, null);
            Cipher cipher = Cipher.getInstance("AES/ECB/NoPadding");
            cipher.init(1, key);
            this.m_id = Base64.getEncoder().encodeToString(cipher.doFinal("0123456789abcdef".getBytes()));
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

