/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import android.content.Context;
import android.graphics.Matrix;
import android.graphics.SurfaceTexture;
import android.os.Handler;
import android.os.Looper;
import android.view.TextureView;
import android.view.View;
import android.widget.FrameLayout;
import com.azure.android.communication.calling.Log;
import com.azure.android.communication.calling.RendererListener;
import com.azure.android.communication.calling.ScalingMode;
import com.azure.android.communication.calling.StreamSize;
import java.util.PriorityQueue;
import java.util.Queue;

abstract class VideoStreamView
extends FrameLayout {
    private static String TAG = "VideoStreamView";
    private static float VIEW_SIZE_THRESHOLD = 5.0f;
    static final int NO_VIDEO_ID = -1;
    protected Context context;
    protected TextureView textureView;
    protected SurfaceTexture surfaceTexture;
    protected ScalingMode scalingMode;
    protected RendererListener callback;
    protected StreamSize streamSize = null;
    protected Queue<TextureView> textureViewQueue;
    protected int videoId;
    protected int w;
    protected int h;

    VideoStreamView(Context context, int videoId, ScalingMode scalingMode) {
        super(context);
        this.context = context;
        this.videoId = videoId;
        this.scalingMode = scalingMode;
        this.textureViewQueue = new PriorityQueue<TextureView>();
        this.setClipChildren(true);
        this.setClipToOutline(true);
    }

    protected void onSizeChanged(int newW, int newH, int oldW, int oldH) {
        super.onSizeChanged(newW, newH, oldW, oldH);
        Log.debug1(TAG, "VideoStreamView size updated new w: %d x h: %d, old w: %d x h: %d", newW, newH, oldW, oldH);
        this.ScaleTextureView();
    }

    protected void ScaleTextureView() {
        Log.debug1(TAG, "Scaling TextureView: %d", System.identityHashCode(this.textureView));
        if (this.textureView == null) {
            Log.debug1(TAG, "Scaling aborted due to invalid TextureView", new Object[0]);
            return;
        }
        if (this.w == 0 || this.h == 0) {
            Log.debug1(TAG, "Scaling aborted due to invalid video frame size", new Object[0]);
            return;
        }
        Log.debug1(TAG, "Calculation parameters, view w: %d x h: %d, video frame w: %d x h: %d", this.getWidth(), this.getHeight(), this.w, this.h);
        float viewW = this.getWidth();
        float viewH = this.getHeight();
        float scaleFactorX = viewW / (float)this.w;
        float scaleFactorY = viewH / (float)this.h;
        float scale = 0.0f;
        switch (this.scalingMode) {
            case FIT: {
                Log.debug1(TAG, "Fitting video frame", new Object[0]);
                scale = Math.min(scaleFactorX, scaleFactorY);
                break;
            }
            case CROP: {
                Log.debug1(TAG, "Cropping video frame", new Object[0]);
                scale = Math.max(scaleFactorX, scaleFactorY);
            }
        }
        float scaledW = scale * (float)this.w;
        float scaledH = scale * (float)this.h;
        float scaleX = scaledW / viewW;
        float scaleY = scaledH / viewH;
        Log.debug1(TAG, "Scale factor: %f, scaled w: %f x h: %f, scaled x: %f, y: %f", Float.valueOf(scale), Float.valueOf(scaledW), Float.valueOf(scaledH), Float.valueOf(scaleX), Float.valueOf(scaleY));
        if (Math.abs(scaledW - viewW) < VIEW_SIZE_THRESHOLD && Math.abs(scaledH - viewH) < VIEW_SIZE_THRESHOLD) {
            Log.debug1(TAG, "Scaled w x h are almost the same meaning the video view container matches the video frame aspect ratio", new Object[0]);
        }
        Matrix matrix = new Matrix();
        matrix.postScale(scaleX, scaleY, viewW / 2.0f, viewH / 2.0f);
        Handler uiHandler = new Handler(Looper.getMainLooper());
        uiHandler.post(() -> {
            Log.debug1(TAG, "Applying transformation viewId: %d", System.identityHashCode(this.textureView));
            this.textureView.setTransform(matrix);
        });
    }

    void UpdateScalingMode(ScalingMode scalingMode) {
        Log.debug1(TAG, "Updating scaling mode new mode: %d, old mode: %d", scalingMode.ordinal(), this.scalingMode.ordinal());
        this.scalingMode = scalingMode;
        this.ScaleTextureView();
    }

    protected StreamSize GetVideoFrameSize() {
        return this.streamSize;
    }

    protected TextureView GetTextureView() {
        return this.textureView;
    }

    protected void AddTextureView() {
        this.textureViewQueue.add(this.textureView);
        Handler uiHandler = new Handler(Looper.getMainLooper());
        uiHandler.post(() -> {
            if (!this.textureViewQueue.isEmpty()) {
                Log.debug1(TAG, "Adding TextureView: %d to VideoStreamView: %d", System.identityHashCode(this.textureView), System.identityHashCode((Object)this));
                this.textureView = this.textureViewQueue.peek();
                this.addView((View)this.textureView);
            }
        });
    }

    protected void RemoveTextureView() {
        if (this.textureView != null) {
            this.textureView.setSurfaceTextureListener(null);
            this.textureView = null;
        }
        Handler uiHandler = new Handler(Looper.getMainLooper());
        uiHandler.post(() -> {
            if (!this.textureViewQueue.isEmpty()) {
                TextureView textureView = this.textureViewQueue.remove();
                Log.debug1(TAG, "Removing TextureView: %d from VideoStreamView: %d", System.identityHashCode(textureView), System.identityHashCode((Object)this));
                this.removeView((View)textureView);
            }
        });
    }
}

