/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import android.content.Context;
import com.azure.android.communication.calling.CallVideoStream;
import com.azure.android.communication.calling.CallingCommunicationErrors;
import com.azure.android.communication.calling.CallingCommunicationException;
import com.azure.android.communication.calling.CreateViewOptions;
import com.azure.android.communication.calling.IVideoStreamRenderer;
import com.azure.android.communication.calling.LocalOutgoingVideoStreamRenderer;
import com.azure.android.communication.calling.LocalVideoStream;
import com.azure.android.communication.calling.RemoteIncomingVideoStreamRenderer;
import com.azure.android.communication.calling.RemoteVideoStream;
import com.azure.android.communication.calling.RendererListener;
import com.azure.android.communication.calling.ScalingMode;
import com.azure.android.communication.calling.StreamSize;
import com.azure.android.communication.calling.VideoStreamRendererView;
import com.azure.android.communication.calling.VideoStreamView;
import com.azure.android.communication.calling.ViewLifecycleTelemetryEvent;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public final class VideoStreamRenderer {
    private static Map<Long, IVideoStreamRenderer> videoStreamRendererMap = new HashMap<Long, IVideoStreamRenderer>();
    private ArrayList<RendererListener> rendererListenerList = new ArrayList();
    private Context context;
    private RendererListenerInternal listener;
    ViewLifecycleTelemetryEvent viewLifecycleEvent;
    private long handle;

    public VideoStreamRenderer(LocalVideoStream localVideoStream, Context context) {
        this(localVideoStream.handle, context, localVideoStream);
    }

    public VideoStreamRenderer(RemoteVideoStream remoteVideoStream, Context context) {
        this(remoteVideoStream.handle, context, remoteVideoStream);
    }

    private VideoStreamRenderer(long handle, Context context, CallVideoStream videoStream) {
        if (videoStreamRendererMap.containsKey(handle)) {
            throw new CallingCommunicationException(CallingCommunicationErrors.MULTIPLE_RENDERERS_NOT_SUPPORTED);
        }
        this.handle = handle;
        this.context = context;
        IVideoStreamRenderer videoStreamRenderer = VideoStreamRenderer.CreateInstance(handle, context, videoStream);
        this.listener = new RendererListenerInternal();
        videoStreamRenderer.SetRendererListener(this.listener);
        switch (videoStream.getType()) {
            case LOCAL_OUTGOING: {
                this.viewLifecycleEvent = ViewLifecycleTelemetryEvent.createForLocalStream(UUID.randomUUID(), (LocalVideoStream)videoStream);
                break;
            }
            case REMOTE_INCOMING: {
                this.viewLifecycleEvent = ViewLifecycleTelemetryEvent.createForRemoteStream(UUID.randomUUID(), (RemoteVideoStream)videoStream);
            }
        }
    }

    static IVideoStreamRenderer GetInstance(long handle) {
        if (videoStreamRendererMap.containsKey(handle)) {
            return videoStreamRendererMap.get(handle);
        }
        return null;
    }

    static IVideoStreamRenderer CreateInstance(long handle, Context context, CallVideoStream videoStream) {
        Closeable videoStreamRenderer = null;
        switch (videoStream.getType()) {
            case LOCAL_OUTGOING: {
                videoStreamRenderer = new LocalOutgoingVideoStreamRenderer(context, (LocalVideoStream)videoStream);
                break;
            }
            case REMOTE_INCOMING: {
                videoStreamRenderer = new RemoteIncomingVideoStreamRenderer(context, (RemoteVideoStream)videoStream);
            }
        }
        videoStreamRendererMap.put(handle, (IVideoStreamRenderer)((Object)videoStreamRenderer));
        return videoStreamRendererMap.get(handle);
    }

    static void RemoveInstance(long handle) {
        if (videoStreamRendererMap.containsKey(handle)) {
            videoStreamRendererMap.remove(handle);
        }
    }

    public VideoStreamRendererView createView() {
        return this.createView(new CreateViewOptions(ScalingMode.CROP));
    }

    public VideoStreamRendererView createView(CreateViewOptions options) {
        this.viewLifecycleEvent.sendCreateViewAttempt();
        IVideoStreamRenderer videoStreamRenderer = videoStreamRendererMap.get(this.handle);
        if (videoStreamRenderer != null) {
            try {
                VideoStreamView videoStreamView = videoStreamRenderer.StartPreview(options);
                VideoStreamRendererView view = new VideoStreamRendererView(this.context, videoStreamView);
                this.viewLifecycleEvent.sendCreateViewSuccess(view.getWidth(), view.getHeight());
                return view;
            }
            catch (Exception e) {
                this.viewLifecycleEvent.sendCreateViewFailed(e.getLocalizedMessage());
                throw e;
            }
        }
        this.viewLifecycleEvent.sendCreateViewFailed("VideoStreamRenderer is already disposed");
        throw new RuntimeException("VideoStreamRenderer is already disposed");
    }

    public void dispose() {
        this.viewLifecycleEvent.sendDisposeViewAttempt();
        IVideoStreamRenderer videoStreamRenderer = videoStreamRendererMap.get(this.handle);
        try {
            if (videoStreamRenderer != null) {
                videoStreamRenderer.StopPreview();
                VideoStreamRenderer.RemoveInstance(this.handle);
                this.viewLifecycleEvent.sendDisposeViewSuccess();
            }
        }
        catch (Exception e) {
            this.viewLifecycleEvent.sendDisposeViewFailed(e.getLocalizedMessage());
        }
    }

    public StreamSize getSize() {
        IVideoStreamRenderer videoStreamRenderer = videoStreamRendererMap.get(this.handle);
        if (videoStreamRenderer != null) {
            return videoStreamRenderer.GetVideoFrameSize();
        }
        return null;
    }

    public void addRendererListener(RendererListener listener) {
        this.rendererListenerList.add(listener);
    }

    public void removeRendererListener(RendererListener listener) {
        this.rendererListenerList.remove(listener);
    }

    private class RendererListenerInternal
    implements RendererListener {
        private RendererListenerInternal() {
        }

        @Override
        public void onFirstFrameRendered() {
            for (RendererListener rendererListener : VideoStreamRenderer.this.rendererListenerList) {
                rendererListener.onFirstFrameRendered();
            }
        }

        @Override
        public void onRendererFailedToStart() {
            for (RendererListener rendererListener : VideoStreamRenderer.this.rendererListenerList) {
                rendererListener.onRendererFailedToStart();
            }
        }
    }
}

