/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import android.content.Context;
import android.view.OrientationEventListener;
import android.view.WindowManager;
import com.azure.android.communication.calling.DeviceManager;
import com.azure.android.communication.calling.Log;
import java.util.ArrayList;
import java.util.Random;

class VideoOrientationManager {
    private static final String TAG = "VideoOrientationManager";
    private static final Random random = new Random();
    private static VideoOrientationManager instance;
    private static Object locker;
    private OrientationEventListener orientationEventListener;
    private final WindowManager windowManager;
    private DeviceManager deviceManager;
    private final ArrayList<OrientationChangedCallback> orientationChangedCallbackList;
    private boolean isEnabled;
    private int orientation = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VideoOrientationManager getInstance(Context context) {
        Object object = locker;
        synchronized (object) {
            if (instance == null) {
                instance = new VideoOrientationManager(context);
            }
        }
        return instance;
    }

    private VideoOrientationManager(Context context) {
        this.windowManager = (WindowManager)context.getSystemService("window");
        if (this.windowManager != null) {
            this.orientationEventListener = new OrientationEventListener(context, 3){

                public void onOrientationChanged(int orientation) {
                    if (orientation != VideoOrientationManager.this.orientation) {
                        Log.debug1(VideoOrientationManager.TAG, "onOrientationChanged: %d", orientation);
                        VideoOrientationManager.this.updateVideoRotation();
                    }
                }
            };
            this.orientation = this.windowManager.getDefaultDisplay().getRotation() * 90;
            Log.debug1(TAG, "Initial orientation: %d", this.orientation);
        } else {
            Log.error(TAG, "Could not get WindowManager for WINDOW_SERVICE", new Object[0]);
        }
        this.orientationChangedCallbackList = new ArrayList();
    }

    public void start() {
        if (this.orientationEventListener != null && this.orientationEventListener.canDetectOrientation()) {
            if (!this.isEnabled) {
                this.isEnabled = true;
                this.orientationEventListener.enable();
                Log.debug1(TAG, "Orientation event listener enabled", new Object[0]);
                this.setDeviceManagerOrientation();
                this.triggerOrientationChanged();
            } else {
                Log.debug1(TAG, "Orientation event listener already enabled", new Object[0]);
            }
        } else {
            Log.warn(TAG, "can not detect orientation events", new Object[0]);
        }
    }

    public void stop() {
        if (this.isEnabled && this.orientationChangedCallbackList.isEmpty()) {
            this.isEnabled = false;
            this.orientationEventListener.disable();
            Log.debug1(TAG, "Orientation event listener disabled", new Object[0]);
        }
    }

    private void triggerOrientationChanged() {
        for (OrientationChangedCallback callback : this.orientationChangedCallbackList) {
            callback.onOrientationChanged(this.orientation);
        }
    }

    private void updateVideoRotation() {
        int rotation = this.windowManager.getDefaultDisplay().getRotation() * 90;
        if (this.orientation == rotation) {
            Log.debug1(TAG, "updateVideoRotation, returning orientation is equal to rotation: %d", rotation);
            return;
        }
        Log.debug1(TAG, "updateVideoRotation, orientation: %d, rotation: %d", this.orientation, rotation);
        this.orientation = rotation;
        this.setDeviceManagerOrientation();
        this.triggerOrientationChanged();
    }

    public int getOrientation() {
        return this.orientation;
    }

    public static void resetDeviceManager() {
        if (instance != null) {
            VideoOrientationManager.instance.deviceManager = null;
        }
    }

    void setDeviceManager(DeviceManager deviceManager) {
        this.deviceManager = deviceManager;
        this.setDeviceManagerOrientation();
    }

    private void setDeviceManagerOrientation() {
        if (this.deviceManager != null) {
            int fixedOrientation = (360 - this.orientation) % 360;
            Log.debug1(TAG, "Orientation for device manager: %d", fixedOrientation);
            this.deviceManager.setDeviceOrientation(fixedOrientation);
        }
    }

    public void addCallback(OrientationChangedCallback orientationChangedCallback) {
        this.orientationChangedCallbackList.add(orientationChangedCallback);
    }

    public void removeCallback(OrientationChangedCallback orientationChangedCallback) {
        this.orientationChangedCallbackList.remove(orientationChangedCallback);
    }

    static {
        locker = new Object();
    }

    public static interface OrientationChangedCallback {
        public void onOrientationChanged(int var1);
    }
}

