/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;

public final class VideoEffectErrorEvent {
    long handle;

    VideoEffectErrorEvent(long ahandle, boolean transfer) {
        this.handle = ahandle;
        if (!transfer) {
            NativeLibrary.sam_video_effect_error_event_args_addref(ahandle);
        }
        ProjectedObjectCache.add(this, this.handle);
    }

    long getHandle() {
        return this.handle;
    }

    protected void finalize() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_video_effect_error_event_args_release(this.handle));
        this.handle = 0L;
    }

    public String getVideoEffectName() {
        Out<String> result = new Out<String>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_video_effect_error_event_args_get_video_effect_name(this.handle, result));
        return (String)result.value;
    }

    public String getCode() {
        Out<String> result = new Out<String>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_video_effect_error_event_args_get_code(this.handle, result));
        return (String)result.value;
    }

    public String getMessage() {
        Out<String> result = new Out<String>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_video_effect_error_event_args_get_message(this.handle, result));
        return (String)result.value;
    }

    static VideoEffectErrorEvent getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.VideoEffectErrorEvent, VideoEffectErrorEvent.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_video_effect_error_event_args_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.VideoEffectErrorEvent, VideoEffectErrorEvent.class, false);
    }
}

