/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.IdentifierHelpers;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import com.azure.android.communication.common.CommunicationIdentifier;

public final class SpotlightedParticipant {
    long handle;

    SpotlightedParticipant(long ahandle, boolean transfer) {
        this.handle = ahandle;
        if (!transfer) {
            NativeLibrary.sam_spotlighted_participant_addref(ahandle);
        }
        ProjectedObjectCache.add(this, this.handle);
    }

    long getHandle() {
        return this.handle;
    }

    protected void finalize() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_spotlighted_participant_release(this.handle));
        this.handle = 0L;
    }

    private String getParticipant() {
        Out<String> result = new Out<String>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_spotlighted_participant_get_participant(this.handle, result));
        return (String)result.value;
    }

    static SpotlightedParticipant getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.SpotlightedParticipant, SpotlightedParticipant.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_spotlighted_participant_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.SpotlightedParticipant, SpotlightedParticipant.class, false);
    }

    public CommunicationIdentifier getIdentifier() {
        return IdentifierHelpers.from(this.getParticipant());
    }
}

