/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.CallClient;
import com.azure.android.communication.calling.JoinMeetingLocator;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import com.azure.android.communication.calling.Status;

public final class RoomCallLocator
extends JoinMeetingLocator {
    RoomCallLocator(long ahandle, boolean transfer) {
        super(ahandle, transfer);
    }

    @Override
    long getHandle() {
        return this.handle;
    }

    static long Create(String roomId) {
        Out<Long> result_handle = new Out<Long>();
        Status resultStatus = NativeLibrary.sam_room_call_locator_create_string_room_id(roomId, result_handle);
        NativeLibraryHelpers.checkStatus((Long)result_handle.value, resultStatus);
        return (Long)result_handle.value;
    }

    public RoomCallLocator(String roomId) {
        super(RoomCallLocator.Create(roomId), true);
    }

    public String getRoomId() {
        Out<String> result = new Out<String>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_room_call_locator_get_room_id(this.handle, result));
        return (String)result.value;
    }

    static RoomCallLocator getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.RoomCallLocator, RoomCallLocator.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_join_meeting_locator_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.RoomCallLocator, RoomCallLocator.class, false);
    }

    static {
        CallClient.loadNativeLibraries();
    }
}

