/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import com.azure.android.communication.calling.RawAudioStreamOptions;
import com.azure.android.communication.calling.RawOutgoingAudioStreamProperties;
import com.azure.android.communication.calling.Status;

public final class RawOutgoingAudioStreamOptions
extends RawAudioStreamOptions {
    RawOutgoingAudioStreamOptions(long ahandle, boolean transfer) {
        super(ahandle, transfer);
    }

    @Override
    long getHandle() {
        return this.handle;
    }

    static long Create() {
        Out<Long> result_handle = new Out<Long>();
        Status resultStatus = NativeLibrary.sam_raw_outgoing_audio_stream_options_create(result_handle);
        NativeLibraryHelpers.checkStatus((Long)result_handle.value, resultStatus);
        return (Long)result_handle.value;
    }

    public RawOutgoingAudioStreamOptions() {
        super(RawOutgoingAudioStreamOptions.Create(), true);
    }

    public RawOutgoingAudioStreamProperties getProperties() {
        Out<Long> result_handle = new Out<Long>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_raw_outgoing_audio_stream_options_get_properties(this.handle, result_handle));
        RawOutgoingAudioStreamProperties result_object = (Long)result_handle.value != 0L ? RawOutgoingAudioStreamProperties.getInstance((Long)result_handle.value, true) : null;
        return result_object;
    }

    public RawOutgoingAudioStreamOptions setProperties(RawOutgoingAudioStreamProperties value) {
        long value_converted = value != null ? value.getHandle() : 0L;
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_raw_outgoing_audio_stream_options_set_properties(this.handle, value_converted));
        return this;
    }

    static RawOutgoingAudioStreamOptions getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.RawOutgoingAudioStreamOptions, RawOutgoingAudioStreamOptions.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_raw_audio_stream_options_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.RawOutgoingAudioStreamOptions, RawOutgoingAudioStreamOptions.class, false);
    }
}

