/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.CallClient;
import com.azure.android.communication.calling.Factories;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.OutgoingAudioFilters;
import com.azure.android.communication.calling.OutgoingAudioStream;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import com.azure.android.communication.calling.Status;

public final class OutgoingAudioOptions {
    long handle;

    OutgoingAudioOptions(long ahandle, boolean transfer) {
        this.handle = ahandle;
        if (!transfer) {
            NativeLibrary.sam_outgoing_audio_options_addref(ahandle);
        }
        ProjectedObjectCache.add(this, this.handle);
    }

    long getHandle() {
        return this.handle;
    }

    public OutgoingAudioOptions() {
        Out<Long> result_handle = new Out<Long>();
        Status resultStatus = NativeLibrary.sam_outgoing_audio_options_create(result_handle);
        this.handle = (Long)result_handle.value;
        NativeLibraryHelpers.checkStatus(this.handle, resultStatus);
        ProjectedObjectCache.add(this, this.handle);
    }

    protected void finalize() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_outgoing_audio_options_release(this.handle));
        this.handle = 0L;
    }

    public boolean isMuted() {
        Out<Boolean> result = new Out<Boolean>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_outgoing_audio_options_get_muted(this.handle, result));
        return (Boolean)result.value;
    }

    public OutgoingAudioOptions setMuted(boolean value) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_outgoing_audio_options_set_muted(this.handle, value));
        return this;
    }

    public OutgoingAudioFilters getFilters() {
        Out<Long> result_handle = new Out<Long>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_outgoing_audio_options_get_filters(this.handle, result_handle));
        OutgoingAudioFilters result_object = (Long)result_handle.value != 0L ? OutgoingAudioFilters.getInstance((Long)result_handle.value, true) : null;
        return result_object;
    }

    public OutgoingAudioOptions setFilters(OutgoingAudioFilters value) {
        long value_converted = value != null ? value.getHandle() : 0L;
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_outgoing_audio_options_set_filters(this.handle, value_converted));
        return this;
    }

    public OutgoingAudioStream getStream() {
        Out<Long> result_handle = new Out<Long>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_outgoing_audio_options_get_stream(this.handle, result_handle));
        OutgoingAudioStream result_object = (Long)result_handle.value != 0L ? Factories.OutgoingAudioStreamFactory((Long)result_handle.value, true) : null;
        return result_object;
    }

    public OutgoingAudioOptions setStream(OutgoingAudioStream value) {
        long value_converted = value != null ? value.getHandle() : 0L;
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_outgoing_audio_options_set_stream(this.handle, value_converted));
        return this;
    }

    public boolean isCommunicationAudioModeEnabled() {
        Out<Boolean> result = new Out<Boolean>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_outgoing_audio_options_get_communication_audio_mode_enabled(this.handle, result));
        return (Boolean)result.value;
    }

    public OutgoingAudioOptions setCommunicationAudioModeEnabled(boolean value) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_outgoing_audio_options_set_communication_audio_mode_enabled(this.handle, value));
        return this;
    }

    static OutgoingAudioOptions getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.OutgoingAudioOptions, OutgoingAudioOptions.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_outgoing_audio_options_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.OutgoingAudioOptions, OutgoingAudioOptions.class, false);
    }

    static {
        CallClient.loadNativeLibraries();
    }
}

