/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.DiagnosticFlagChangedEvent;
import com.azure.android.communication.calling.DiagnosticFlagChangedListener;
import com.azure.android.communication.calling.DiagnosticQualityChangedEvent;
import com.azure.android.communication.calling.DiagnosticQualityChangedListener;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.NetworkDiagnosticValues;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import com.azure.android.communication.calling.ProjectedObjectEventHandlerCache;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public final class NetworkDiagnostics {
    long handle;
    private List<DiagnosticFlagChangedListener> OnIsNetworkUnavailableChangedListeners = new CopyOnWriteArrayList<DiagnosticFlagChangedListener>();
    private List<DiagnosticFlagChangedListener> OnIsNetworkRelaysUnreachableChangedListeners = new CopyOnWriteArrayList<DiagnosticFlagChangedListener>();
    private List<DiagnosticQualityChangedListener> OnNetworkReconnectionQualityChangedListeners = new CopyOnWriteArrayList<DiagnosticQualityChangedListener>();
    private List<DiagnosticQualityChangedListener> OnNetworkReceiveQualityChangedListeners = new CopyOnWriteArrayList<DiagnosticQualityChangedListener>();
    private List<DiagnosticQualityChangedListener> OnNetworkSendQualityChangedListeners = new CopyOnWriteArrayList<DiagnosticQualityChangedListener>();

    NetworkDiagnostics(long ahandle, boolean transfer) {
        this.handle = ahandle;
        if (!transfer) {
            NativeLibrary.sam_network_diagnostics_addref(ahandle);
        }
        ProjectedObjectCache.add(this, this.handle);
    }

    NetworkDiagnostics(long ahandle, boolean transfer, boolean restoreEventHandlers) {
        this(ahandle, transfer);
        if (restoreEventHandlers) {
            this.restoreEventHandlers();
        }
    }

    long getHandle() {
        return this.handle;
    }

    protected void finalize() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_network_diagnostics_release(this.handle));
        this.handle = 0L;
    }

    private NetworkDiagnosticValues getLatestInternal() {
        Out<Long> result_handle = new Out<Long>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_network_diagnostics_get_latest_internal(this.handle, result_handle));
        NetworkDiagnosticValues result_object = (Long)result_handle.value != 0L ? NetworkDiagnosticValues.getInstance((Long)result_handle.value, true) : null;
        return result_object;
    }

    private static void OnIsNetworkUnavailableChangedStaticHandler(long cookie, long args) {
        NetworkDiagnostics instance = NetworkDiagnostics.getInstance(cookie);
        if (instance != null) {
            DiagnosticFlagChangedEvent args_converted = args != 0L ? DiagnosticFlagChangedEvent.getInstance(args, false) : null;
            for (DiagnosticFlagChangedListener listener : instance.OnIsNetworkUnavailableChangedListeners) {
                listener.onDiagnosticFlagChanged(args_converted);
            }
        }
    }

    public void addOnIsNetworkUnavailableChangedListener(DiagnosticFlagChangedListener listener) {
        this.OnIsNetworkUnavailableChangedListeners.add(listener);
        ProjectedObjectEventHandlerCache.addEventHandler(this, this.getHandle(), "OnIsNetworkUnavailableChanged", listener);
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_network_diagnostics_set_on_is_network_unavailable_changed(this.handle, this.getHandle(), this));
    }

    public void removeOnIsNetworkUnavailableChangedListener(DiagnosticFlagChangedListener listener) {
        this.OnIsNetworkUnavailableChangedListeners.remove(listener);
        if (ProjectedObjectEventHandlerCache.removeEventHandler(this, this.getHandle(), "OnIsNetworkUnavailableChanged", listener)) {
            NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_network_diagnostics_set_on_is_network_unavailable_changed(this.handle, 0L, null));
        }
    }

    private static void OnIsNetworkRelaysUnreachableChangedStaticHandler(long cookie, long args) {
        NetworkDiagnostics instance = NetworkDiagnostics.getInstance(cookie);
        if (instance != null) {
            DiagnosticFlagChangedEvent args_converted = args != 0L ? DiagnosticFlagChangedEvent.getInstance(args, false) : null;
            for (DiagnosticFlagChangedListener listener : instance.OnIsNetworkRelaysUnreachableChangedListeners) {
                listener.onDiagnosticFlagChanged(args_converted);
            }
        }
    }

    public void addOnIsNetworkRelaysUnreachableChangedListener(DiagnosticFlagChangedListener listener) {
        this.OnIsNetworkRelaysUnreachableChangedListeners.add(listener);
        ProjectedObjectEventHandlerCache.addEventHandler(this, this.getHandle(), "OnIsNetworkRelaysUnreachableChanged", listener);
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_network_diagnostics_set_on_is_network_relays_unreachable_changed(this.handle, this.getHandle(), this));
    }

    public void removeOnIsNetworkRelaysUnreachableChangedListener(DiagnosticFlagChangedListener listener) {
        this.OnIsNetworkRelaysUnreachableChangedListeners.remove(listener);
        if (ProjectedObjectEventHandlerCache.removeEventHandler(this, this.getHandle(), "OnIsNetworkRelaysUnreachableChanged", listener)) {
            NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_network_diagnostics_set_on_is_network_relays_unreachable_changed(this.handle, 0L, null));
        }
    }

    private static void OnNetworkReconnectionQualityChangedStaticHandler(long cookie, long args) {
        NetworkDiagnostics instance = NetworkDiagnostics.getInstance(cookie);
        if (instance != null) {
            DiagnosticQualityChangedEvent args_converted = args != 0L ? DiagnosticQualityChangedEvent.getInstance(args, false) : null;
            for (DiagnosticQualityChangedListener listener : instance.OnNetworkReconnectionQualityChangedListeners) {
                listener.onDiagnosticQualityChanged(args_converted);
            }
        }
    }

    public void addOnNetworkReconnectionQualityChangedListener(DiagnosticQualityChangedListener listener) {
        this.OnNetworkReconnectionQualityChangedListeners.add(listener);
        ProjectedObjectEventHandlerCache.addEventHandler(this, this.getHandle(), "OnNetworkReconnectionQualityChanged", listener);
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_network_diagnostics_set_on_network_reconnection_quality_changed(this.handle, this.getHandle(), this));
    }

    public void removeOnNetworkReconnectionQualityChangedListener(DiagnosticQualityChangedListener listener) {
        this.OnNetworkReconnectionQualityChangedListeners.remove(listener);
        if (ProjectedObjectEventHandlerCache.removeEventHandler(this, this.getHandle(), "OnNetworkReconnectionQualityChanged", listener)) {
            NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_network_diagnostics_set_on_network_reconnection_quality_changed(this.handle, 0L, null));
        }
    }

    private static void OnNetworkReceiveQualityChangedStaticHandler(long cookie, long args) {
        NetworkDiagnostics instance = NetworkDiagnostics.getInstance(cookie);
        if (instance != null) {
            DiagnosticQualityChangedEvent args_converted = args != 0L ? DiagnosticQualityChangedEvent.getInstance(args, false) : null;
            for (DiagnosticQualityChangedListener listener : instance.OnNetworkReceiveQualityChangedListeners) {
                listener.onDiagnosticQualityChanged(args_converted);
            }
        }
    }

    public void addOnNetworkReceiveQualityChangedListener(DiagnosticQualityChangedListener listener) {
        this.OnNetworkReceiveQualityChangedListeners.add(listener);
        ProjectedObjectEventHandlerCache.addEventHandler(this, this.getHandle(), "OnNetworkReceiveQualityChanged", listener);
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_network_diagnostics_set_on_network_receive_quality_changed(this.handle, this.getHandle(), this));
    }

    public void removeOnNetworkReceiveQualityChangedListener(DiagnosticQualityChangedListener listener) {
        this.OnNetworkReceiveQualityChangedListeners.remove(listener);
        if (ProjectedObjectEventHandlerCache.removeEventHandler(this, this.getHandle(), "OnNetworkReceiveQualityChanged", listener)) {
            NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_network_diagnostics_set_on_network_receive_quality_changed(this.handle, 0L, null));
        }
    }

    private static void OnNetworkSendQualityChangedStaticHandler(long cookie, long args) {
        NetworkDiagnostics instance = NetworkDiagnostics.getInstance(cookie);
        if (instance != null) {
            DiagnosticQualityChangedEvent args_converted = args != 0L ? DiagnosticQualityChangedEvent.getInstance(args, false) : null;
            for (DiagnosticQualityChangedListener listener : instance.OnNetworkSendQualityChangedListeners) {
                listener.onDiagnosticQualityChanged(args_converted);
            }
        }
    }

    public void addOnNetworkSendQualityChangedListener(DiagnosticQualityChangedListener listener) {
        this.OnNetworkSendQualityChangedListeners.add(listener);
        ProjectedObjectEventHandlerCache.addEventHandler(this, this.getHandle(), "OnNetworkSendQualityChanged", listener);
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_network_diagnostics_set_on_network_send_quality_changed(this.handle, this.getHandle(), this));
    }

    public void removeOnNetworkSendQualityChangedListener(DiagnosticQualityChangedListener listener) {
        this.OnNetworkSendQualityChangedListeners.remove(listener);
        if (ProjectedObjectEventHandlerCache.removeEventHandler(this, this.getHandle(), "OnNetworkSendQualityChanged", listener)) {
            NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_network_diagnostics_set_on_network_send_quality_changed(this.handle, 0L, null));
        }
    }

    static NetworkDiagnostics getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.NetworkDiagnostics, NetworkDiagnostics.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_network_diagnostics_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.NetworkDiagnostics, NetworkDiagnostics.class, false);
    }

    private static NetworkDiagnostics getInstance(long cookie) {
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.NetworkDiagnostics, NetworkDiagnostics.class, false);
    }

    void restoreEventHandlers() {
        for (Object eventListener : ProjectedObjectEventHandlerCache.getEventHandlers(this, this.getHandle(), "OnIsNetworkUnavailableChanged")) {
            this.addOnIsNetworkUnavailableChangedListener((DiagnosticFlagChangedListener)eventListener);
        }
        for (Object eventListener : ProjectedObjectEventHandlerCache.getEventHandlers(this, this.getHandle(), "OnIsNetworkRelaysUnreachableChanged")) {
            this.addOnIsNetworkRelaysUnreachableChangedListener((DiagnosticFlagChangedListener)eventListener);
        }
        for (Object eventListener : ProjectedObjectEventHandlerCache.getEventHandlers(this, this.getHandle(), "OnNetworkReconnectionQualityChanged")) {
            this.addOnNetworkReconnectionQualityChangedListener((DiagnosticQualityChangedListener)eventListener);
        }
        for (Object eventListener : ProjectedObjectEventHandlerCache.getEventHandlers(this, this.getHandle(), "OnNetworkReceiveQualityChanged")) {
            this.addOnNetworkReceiveQualityChangedListener((DiagnosticQualityChangedListener)eventListener);
        }
        for (Object eventListener : ProjectedObjectEventHandlerCache.getEventHandlers(this, this.getHandle(), "OnNetworkSendQualityChanged")) {
            this.addOnNetworkSendQualityChangedListener((DiagnosticQualityChangedListener)eventListener);
        }
    }

    public NetworkDiagnosticValues getLatestDiagnostics() {
        return this.getLatestInternal();
    }
}

