/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import com.azure.android.communication.calling.Status;
import com.azure.android.communication.calling.VideoStreamType;

public final class IncomingVideoOptions {
    long handle;

    IncomingVideoOptions(long ahandle, boolean transfer) {
        this.handle = ahandle;
        if (!transfer) {
            NativeLibrary.sam_incoming_video_options_addref(ahandle);
        }
        ProjectedObjectCache.add(this, this.handle);
    }

    long getHandle() {
        return this.handle;
    }

    public IncomingVideoOptions() {
        Out<Long> result_handle = new Out<Long>();
        Status resultStatus = NativeLibrary.sam_incoming_video_options_create(result_handle);
        this.handle = (Long)result_handle.value;
        NativeLibraryHelpers.checkStatus(this.handle, resultStatus);
        ProjectedObjectCache.add(this, this.handle);
    }

    protected void finalize() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_incoming_video_options_release(this.handle));
        this.handle = 0L;
    }

    public VideoStreamType getStreamType() {
        Out<VideoStreamType> result = new Out<VideoStreamType>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_incoming_video_options_get_stream_type(this.handle, result));
        return (VideoStreamType)((Object)result.value);
    }

    public IncomingVideoOptions setStreamType(VideoStreamType value) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_incoming_video_options_set_stream_type(this.handle, value));
        return this;
    }

    static IncomingVideoOptions getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.IncomingVideoOptions, IncomingVideoOptions.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_incoming_video_options_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.IncomingVideoOptions, IncomingVideoOptions.class, false);
    }
}

