/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.CallFeature;
import com.azure.android.communication.calling.DominantSpeakersInfo;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import com.azure.android.communication.calling.ProjectedObjectEventHandlerCache;
import com.azure.android.communication.calling.PropertyChangedEvent;
import com.azure.android.communication.calling.PropertyChangedListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public final class DominantSpeakersCallFeature
extends CallFeature {
    private List<PropertyChangedListener> OnDominantSpeakersChangedListeners = new CopyOnWriteArrayList<PropertyChangedListener>();

    DominantSpeakersCallFeature(long ahandle, boolean transfer) {
        super(ahandle, transfer);
    }

    DominantSpeakersCallFeature(long ahandle, boolean transfer, boolean restoreEventHandlers) {
        this(ahandle, transfer);
        if (restoreEventHandlers) {
            this.restoreEventHandlers();
        }
    }

    @Override
    long getHandle() {
        return this.handle;
    }

    public DominantSpeakersInfo getDominantSpeakersInfo() {
        Out<Long> result_handle = new Out<Long>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_dominant_speakers_call_feature_get_dominant_speakers_info(this.handle, result_handle));
        DominantSpeakersInfo result_object = (Long)result_handle.value != 0L ? DominantSpeakersInfo.getInstance((Long)result_handle.value, true) : null;
        return result_object;
    }

    private static void OnDominantSpeakersChangedStaticHandler(long cookie, long args) {
        DominantSpeakersCallFeature instance = DominantSpeakersCallFeature.getInstance(cookie);
        if (instance != null) {
            PropertyChangedEvent args_converted = args != 0L ? PropertyChangedEvent.getInstance(args, false) : null;
            for (PropertyChangedListener listener : instance.OnDominantSpeakersChangedListeners) {
                listener.onPropertyChanged(args_converted);
            }
        }
    }

    public void addOnDominantSpeakersChangedListener(PropertyChangedListener listener) {
        this.OnDominantSpeakersChangedListeners.add(listener);
        ProjectedObjectEventHandlerCache.addEventHandler(this, this.getHandle(), "OnDominantSpeakersChanged", listener);
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_dominant_speakers_call_feature_set_on_dominant_speakers_changed(this.handle, this.getHandle(), this));
    }

    public void removeOnDominantSpeakersChangedListener(PropertyChangedListener listener) {
        this.OnDominantSpeakersChangedListeners.remove(listener);
        if (ProjectedObjectEventHandlerCache.removeEventHandler(this, this.getHandle(), "OnDominantSpeakersChanged", listener)) {
            NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_dominant_speakers_call_feature_set_on_dominant_speakers_changed(this.handle, 0L, null));
        }
    }

    static DominantSpeakersCallFeature getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.DominantSpeakersCallFeature, DominantSpeakersCallFeature.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_call_feature_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.DominantSpeakersCallFeature, DominantSpeakersCallFeature.class, false);
    }

    private static DominantSpeakersCallFeature getInstance(long cookie) {
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.DominantSpeakersCallFeature, DominantSpeakersCallFeature.class, false);
    }

    void restoreEventHandlers() {
        for (Object eventListener : ProjectedObjectEventHandlerCache.getEventHandlers(this, this.getHandle(), "OnDominantSpeakersChanged")) {
            this.addOnDominantSpeakersChangedListener((PropertyChangedListener)eventListener);
        }
    }
}

