/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.CaptionsType;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.StartCaptionsOptions;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java9.util.concurrent.CompletableFuture;

public abstract class CallCaptions {
    private static final ExecutorService executor = Executors.newCachedThreadPool();
    long handle;

    CallCaptions(long ahandle, boolean transfer) {
        this.handle = ahandle;
        if (!transfer) {
            NativeLibrary.sam_call_captions_addref(ahandle);
        }
        ProjectedObjectCache.add(this, this.handle);
    }

    long getHandle() {
        return this.handle;
    }

    protected void finalize() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_captions_release(this.handle));
        this.handle = 0L;
    }

    private String[] getSupportedSpokenLanguagesInternal() {
        Out<String[]> result = new Out<String[]>();
        Out<Integer> result_length = new Out<Integer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_captions_get_supported_spoken_languages_internal(this.handle, result, result_length));
        return (String[])result.value;
    }

    public List<String> getSupportedSpokenLanguages() {
        Out<String[]> result = new Out<String[]>();
        Out<Integer> result_length = new Out<Integer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_captions_get_supported_spoken_languages(this.handle, result, result_length));
        return Arrays.asList((Object[])result.value);
    }

    public boolean isEnabled() {
        Out<Boolean> result = new Out<Boolean>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_captions_get_is_enabled(this.handle, result));
        return (Boolean)result.value;
    }

    public CaptionsType getCaptionsType() {
        Out<CaptionsType> result = new Out<CaptionsType>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_captions_get_captions_type(this.handle, result));
        return (CaptionsType)((Object)result.value);
    }

    public String getActiveSpokenLanguage() {
        Out<String> result = new Out<String>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_captions_get_active_spoken_language(this.handle, result));
        return (String)result.value;
    }

    public CompletableFuture<Void> startCaptions(final StartCaptionsOptions options) {
        final long handle = this.handle;
        return CompletableFuture.runAsync((Runnable)new Runnable(){

            @Override
            public void run() {
                long options_converted = options != null ? options.getHandle() : 0L;
                NativeLibraryHelpers.checkStatus(handle, NativeLibrary.sam_call_captions_start_captions(handle, options_converted));
            }
        }, (Executor)executor);
    }

    public CompletableFuture<Void> stopCaptions() {
        final long handle = this.handle;
        return CompletableFuture.runAsync((Runnable)new Runnable(){

            @Override
            public void run() {
                NativeLibraryHelpers.checkStatus(handle, NativeLibrary.sam_call_captions_stop_captions(handle));
            }
        }, (Executor)executor);
    }

    public CompletableFuture<Void> setSpokenLanguage(final String language) {
        final long handle = this.handle;
        return CompletableFuture.runAsync((Runnable)new Runnable(){

            @Override
            public void run() {
                NativeLibraryHelpers.checkStatus(handle, NativeLibrary.sam_call_captions_set_spoken_language(handle, language));
            }
        }, (Executor)executor);
    }
}

