/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

abstract class BasePrivateList<T>
implements List<T> {
    BasePrivateList() {
    }

    abstract int InternalGetCount();

    abstract T InternalGetItem(int var1);

    abstract void InternalSetItem(int var1, T var2);

    abstract void InternalRemoveItem(int var1);

    @Override
    public boolean add(T item) {
        this.InternalSetItem(this.InternalGetCount(), item);
        return true;
    }

    @Override
    public void add(int index, T item) {
        this.InternalSetItem(index, item);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        for (T item : c) {
            this.add(item);
        }
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        int i = index;
        for (T item : c) {
            this.add(i++, item);
        }
        return true;
    }

    @Override
    public void clear() {
        while (this.InternalGetCount() > 0) {
            this.InternalRemoveItem(0);
        }
    }

    @Override
    public boolean contains(Object item) {
        return this.indexOf(item) >= 0;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public T get(int index) {
        return this.InternalGetItem(index);
    }

    @Override
    public int indexOf(Object item) {
        int count = this.InternalGetCount();
        for (int i = 0; i < count; ++i) {
            if (!item.equals(this.InternalGetItem(i))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean isEmpty() {
        return this.size() > 0;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private int currIndex = 0;

            @Override
            public boolean hasNext() {
                return this.currIndex < BasePrivateList.this.size();
            }

            @Override
            public T next() {
                return BasePrivateList.this.get(this.currIndex++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        };
    }

    @Override
    public int lastIndexOf(Object item) {
        int count = this.InternalGetCount();
        for (int i = count - 1; i >= 0; --i) {
            if (!item.equals(this.InternalGetItem(i))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public ListIterator<T> listIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T set(int index, T value) {
        this.InternalSetItem(index, value);
        return value;
    }

    @Override
    public T remove(int index) {
        T item = this.get(index);
        this.InternalRemoveItem(index);
        return item;
    }

    @Override
    public boolean remove(Object item) {
        int index = this.indexOf(item);
        if (index < 0) {
            return false;
        }
        this.InternalRemoveItem(index);
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = false;
        for (Object item : c) {
            changed |= this.remove(item);
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        ArrayList<T> toRemove = new ArrayList<T>();
        for (T item : this) {
            if (c.contains(item)) continue;
            toRemove.add(item);
        }
        return this.removeAll(toRemove);
    }

    @Override
    public int size() {
        return this.InternalGetCount();
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        Object[] array = new Object[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            array[i] = this.get(i);
        }
        return array;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.toArray();
    }
}

