/*
 * Decompiled with CFR 0.152.
 */
package com.skype.android.video.hw.utils;

import android.graphics.SurfaceTexture;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaFormat;
import android.os.Build;
import android.util.Range;
import android.view.Surface;
import com.skype.android.video.hw.format.Capabilities;
import com.skype.android.video.hw.format.ColorFormat;
import com.skype.android.video.hw.format.H264Level;
import com.skype.android.video.hw.format.H264Profile;
import com.skype.android.video.hw.utils.DummyMediaCodec;
import com.skype.android.video.hw.utils.Log;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CodecUtils {
    public static final String MEDIA_TYPE = "video/avc";
    public static final String[] omxCapableHW = new String[]{"OMX.Intel.hw_ve.h264", "OMX.Exynos.AVC.Encoder", "OMX.MTK.VIDEO.ENCODER.AVC"};
    private static final int Driver_ExynosLTRFix = 180315;
    static final int SUPPORT_QC_EXTENTSION = 1;
    static final int SUPPORT_AFTER_NOUGAT_EXTENSION = 2;

    public static String[] enumEncoders() {
        Object[] names = CapabilitiesHandler.enumCodecs(true);
        Arrays.sort(names);
        return names;
    }

    public static String[] enumDecoders() {
        Object[] names = CapabilitiesHandler.enumCodecs(false);
        Arrays.sort(names);
        return names;
    }

    public static Capabilities getEncoderCapabilities(String encoderName) {
        return CapabilitiesHandler.getEncoderCapabilities().get(encoderName);
    }

    public static Capabilities getDecoderCapabilities(String decoderName) {
        return CapabilitiesHandler.getDecoderCapabilities().get(decoderName);
    }

    private static Map<String, Capabilities> getAllCapabilities(boolean isEncoder) {
        HashMap<String, Capabilities> codecCapabilities;
        block8: {
            boolean isHwEncoderApiSupported = Build.VERSION.SDK_INT >= 18;
            boolean isHwDecoderApiSupported = Build.VERSION.SDK_INT >= 16;
            boolean isAPI21orHigher = Build.VERSION.SDK_INT >= 21;
            codecCapabilities = new HashMap<String, Capabilities>();
            try {
                if (isHwEncoderApiSupported || isHwDecoderApiSupported) {
                    if (isAPI21orHigher) {
                        MediaCodecInfo[] codecInfos;
                        MediaCodecList codecList = new MediaCodecList(1);
                        for (MediaCodecInfo codecInfo : codecInfos = codecList.getCodecInfos()) {
                            if (codecInfo.isEncoder() != isEncoder || !(isEncoder ? isHwEncoderApiSupported : isHwDecoderApiSupported)) continue;
                            CodecUtils.getCodecCapabilities(codecCapabilities, codecInfo, codecInfo.isEncoder());
                        }
                    } else {
                        for (int i = 0; i < MediaCodecList.getCodecCount(); ++i) {
                            MediaCodecInfo codecInfo = MediaCodecList.getCodecInfoAt((int)i);
                            if (codecInfo.isEncoder() != isEncoder || !(isEncoder ? isHwEncoderApiSupported : isHwDecoderApiSupported)) continue;
                            CodecUtils.getCodecCapabilities(codecCapabilities, codecInfo, codecInfo.isEncoder());
                        }
                    }
                }
                for (Capabilities caps : codecCapabilities.values()) {
                    if (!Log.isLoggable("SLIQ", 4)) continue;
                    Log.i("SLIQ", MEDIA_TYPE + (isEncoder ? " encoder detected: " : " decoder detected: ") + caps);
                }
            }
            catch (RuntimeException e) {
                if (!Log.isLoggable("SLIQ", 6)) break block8;
                Log.e("SLIQ", "Exception caught", e);
            }
        }
        return codecCapabilities;
    }

    private static MediaFormat getNewQCMediaExtAfterNougat(boolean isEncoder, String extPrefix, boolean isExynos) {
        try {
            DummyMediaCodec dummyCodec = new DummyMediaCodec(isEncoder, isExynos);
            dummyCodec.init(640, 360, extPrefix);
            dummyCodec.start();
            dummyCodec.callbackCountDown.await(5L, TimeUnit.SECONDS);
            dummyCodec.stop();
            if (isEncoder) {
                if (dummyCodec.mEncOutputFormat != null) {
                    if (dummyCodec.mEncOutputFormat.containsKey(extPrefix + "-ext-enc-caps-vt-driver-version.number")) {
                        int driver;
                        if (isExynos && (driver = dummyCodec.mEncOutputFormat.getInteger(extPrefix + "-ext-enc-caps-vt-driver-version.number")) < 180315) {
                            Log.i("SLIQ", "dummy MediaCodec driver smaller than ExynosLTRFix driver.");
                            return null;
                        }
                        return dummyCodec.mEncOutputFormat;
                    }
                    Log.i("SLIQ", "dummy MediaCodec mEncOutputFormat does not contains ext key.");
                    return null;
                }
                Log.i("SLIQ", "dummy MediaCodec mEncOutputFormat is null.");
                return null;
            }
            if (dummyCodec.mDecOutputFormat != null) {
                if (dummyCodec.mDecOutputFormat.containsKey(extPrefix + "-ext-dec-caps-vt-driver-version.number")) {
                    return dummyCodec.mDecOutputFormat;
                }
                if (isExynos && dummyCodec.mDecOutputFormat.containsKey(extPrefix + "-ext-enc-caps-vt-driver-version.number")) {
                    return dummyCodec.mDecOutputFormat;
                }
                Log.i("SLIQ", "dummy MediaCodec mDecOutputFormat does not contains ext key.");
                return null;
            }
            Log.i("SLIQ", "dummy MediaCodec mDecOutputFormat is null.");
            return null;
        }
        catch (Exception e) {
            Log.e("SLIQ", "Exception caught", e);
            return null;
        }
    }

    private static void getCodecCapabilities(Map<String, Capabilities> codecCapabilities, MediaCodecInfo codecInfo, boolean isEncoder) {
        boolean isVideoCapsAvailable = Build.VERSION.SDK_INT >= 21;
        String extPrefix = "vendor.rtc";
        for (String mediaType : codecInfo.getSupportedTypes()) {
            boolean isNewQCMediaExtAfterNougat;
            Log.i("SLIQ", "getCodecCapabilities mediaType=" + mediaType);
            Log.i("SLIQ", "getCodecCapabilities codecInfo.getName()=" + codecInfo.getName());
            if (!MEDIA_TYPE.equalsIgnoreCase(mediaType) || codecInfo.getName().toLowerCase(Locale.ROOT).startsWith("omx.google.") || codecInfo.getName().toLowerCase(Locale.ROOT).startsWith("omx.sec.") || codecInfo.getName().toLowerCase(Locale.ROOT).endsWith(".secure")) continue;
            MediaCodecInfo.CodecCapabilities caps = codecInfo.getCapabilitiesForType(MEDIA_TYPE);
            MediaFormat extCaps = null;
            boolean bl = isNewQCMediaExtAfterNougat = Build.VERSION.SDK_INT >= 26;
            if (!isNewQCMediaExtAfterNougat) {
                Log.i("SLIQ", "isNewQCMediaExtAfterNougat false path");
                Class<?> cls = caps.getClass();
                Method method = null;
                try {
                    method = cls.getDeclaredMethod("getCapabilitiesInfoFormat", new Class[0]);
                    extCaps = (MediaFormat)method.invoke((Object)caps, new Object[0]);
                }
                catch (NoSuchMethodException e) {
                    Log.w("SLIQ", "Could not find getCapabilitiesInfoFormat");
                }
                catch (IllegalAccessException e) {
                    Log.w("SLIQ", "Could not find getCapabilitiesInfoFormat");
                }
                catch (InvocationTargetException e) {
                    Log.w("SLIQ", "Could not find getCapabilitiesInfoFormat");
                }
                catch (IllegalArgumentException e) {
                    Log.w("SLIQ", "Could not find getCapabilitiesInfoFormat");
                }
            } else {
                boolean isQCCodecName = codecInfo.getName().toLowerCase(Locale.ROOT).contains("qcom") || codecInfo.getName().toLowerCase(Locale.ROOT).contains("qti");
                extPrefix = isQCCodecName ? "vendor.qti" : "vendor.rtc";
                Log.i("SLIQ", "isNewQCMediaExtAfterNougat true path extprefix: " + extPrefix);
                extCaps = CodecUtils.getNewQCMediaExtAfterNougat(isEncoder, extPrefix, codecInfo.getName().toLowerCase(Locale.ROOT).contains("exynos"));
            }
            if (caps.colorFormats.length <= 0 || caps.profileLevels.length <= 0) {
                Log.i("SLIQ", "getCodecCapabilities caps.colorFormats.length is " + caps.colorFormats.length);
                Log.i("SLIQ", "getCodecCapabilities caps.profileLevels.length is " + caps.profileLevels.length);
                continue;
            }
            if (!isVideoCapsAvailable) continue;
            Range widthRange = null;
            Range heightRange = null;
            Range bitrateRange = null;
            Boolean supportQCExtension = false;
            MediaCodecInfo.VideoCapabilities vidCaps = caps.getVideoCapabilities();
            widthRange = vidCaps.getSupportedWidths();
            heightRange = vidCaps.getSupportedHeights();
            bitrateRange = vidCaps.getBitrateRange();
            supportQCExtension = false;
            if (extCaps != null) {
                if (!isNewQCMediaExtAfterNougat) {
                    String version = extCaps.getString("vt-version");
                    if (version != null) {
                        supportQCExtension = true;
                        Log.d("SLIQ", codecInfo.getName() + " vt-version returned: " + version);
                    } else {
                        Log.e("SLIQ", codecInfo.getName() + " vt-version returned: null");
                    }
                } else if (extCaps.containsKey(extPrefix + "-ext-enc-caps-vt-driver-version.number") || extCaps.containsKey(extPrefix + "-ext-dec-caps-vt-driver-version.number")) {
                    supportQCExtension = true;
                    if (isEncoder) {
                        Log.i("SLIQ", codecInfo.getName() + ":" + extPrefix + "-ext-enc-caps-vt-driver-version.number: " + extCaps.getInteger(extPrefix + "-ext-enc-caps-vt-driver-version.number"));
                    } else {
                        Log.i("SLIQ", codecInfo.getName() + ":" + extPrefix + "-ext-dec-caps-vt-driver-version.number: " + extCaps.getInteger(extPrefix + "-ext-dec-caps-vt-driver-version.number"));
                    }
                } else if (isEncoder) {
                    Log.e("SLIQ", codecInfo.getName() + ":" + extPrefix + "-ext-enc-caps-vt-driver-version.number: null");
                } else {
                    Log.e("SLIQ", codecInfo.getName() + ":" + extPrefix + "-ext-dec-caps-vt-driver-version.number: null");
                }
            } else {
                Log.i("SLIQ", codecInfo.getName() + " extCaps is null.");
            }
            if (supportQCExtension.booleanValue()) {
                if (!isNewQCMediaExtAfterNougat) {
                    if (isEncoder) {
                        Log.i("SLIQ", codecInfo.getName() + " supports VTVideoCapabilities:");
                        Log.i("SLIQ", "getVersion() =>                     " + extCaps.getString("vt-version"));
                        Log.i("SLIQ", "isLowLatencySupported() =>          " + extCaps.getString("vt-low-latency"));
                        Log.i("SLIQ", "getMaxInstances() =>                " + extCaps.getString("vt-max-instances"));
                        Log.i("SLIQ", "getMaxTemporalLayerCount() =>       " + extCaps.getString("vt-max-temporal-layer-count"));
                        Log.i("SLIQ", "getMaxRefFrames() =>                " + extCaps.getString("vt-max-ref-frames"));
                        Log.i("SLIQ", "getMaxLTRFrames() =>                " + extCaps.getString("vt-max-ltr-frames"));
                        Log.i("SLIQ", "getMaxLevel() =>                    " + extCaps.getString("vt-max-level"));
                        Log.i("SLIQ", "getSliceControlModesBM() =>         " + extCaps.getString("vt-slice-control-modes-bitmask"));
                        Log.i("SLIQ", "getMaxMacroblockProcessingRate() => " + extCaps.getString("vt-max-macroblock-processing-rate"));
                        Log.i("SLIQ", "getSupportedDownScaleFactor() =>    " + extCaps.getString("vt-down-scale-factor"));
                        Log.i("SLIQ", "getMinScaleFactor() =>              " + extCaps.getString("vt-min-scale-factor"));
                    } else {
                        Log.i("SLIQ", codecInfo.getName() + " supports VTVideoCapabilities:");
                        Log.i("SLIQ", "getVersion() =>                     " + extCaps.getString("vt-version"));
                        Log.i("SLIQ", "isLowLatencySupported() =>          " + extCaps.getString("vt-low-latency"));
                        Log.i("SLIQ", "getMaxInstances() =>                " + extCaps.getString("vt-max-instances"));
                        Log.i("SLIQ", "getMaxLevel() =>                    " + extCaps.getString("vt-max-level"));
                        Log.i("SLIQ", "getMaxMacroblockProcessingRate() => " + extCaps.getString("vt-max-macroblock-processing-rate"));
                    }
                }
                Capabilities capabilities = CodecUtils.mapCapabilities(codecInfo.getName(), caps, (Range<Integer>)widthRange, (Range<Integer>)heightRange, (Range<Integer>)bitrateRange, extCaps);
                Log.i("SLIQ", "getCodecCapabilities@Add " + codecInfo.getName() + "::" + (Build.VERSION.SDK_INT >= 29 && !codecInfo.getCanonicalName().isEmpty() ? "(Canonical name: " + codecInfo.getCanonicalName() + ")" : "") + capabilities);
                codecCapabilities.put(codecInfo.getName(), capabilities);
                continue;
            }
            Log.i("SLIQ", codecInfo.getName() + " does not support VTVideoCapabilities.");
        }
    }

    private static Capabilities mapCapabilities(String codecName, MediaCodecInfo.CodecCapabilities codecCapabilities, Range<Integer> widthRange, Range<Integer> heightRange, Range<Integer> bitrateRange, MediaFormat extCaps) {
        HashSet<H264Profile> profiles = new HashSet<H264Profile>();
        HashSet<H264Level> levels = new HashSet<H264Level>();
        for (MediaCodecInfo.CodecProfileLevel pl : codecCapabilities.profileLevels) {
            block8: {
                try {
                    profiles.add(H264Profile.fromOmx(pl.profile));
                }
                catch (NoSuchElementException e) {
                    if (!Log.isLoggable("SLIQ", 4)) break block8;
                    Log.i("SLIQ", "OMX H.264 profile " + pl.profile + " is not supported");
                }
            }
            try {
                levels.add(H264Level.fromOmx(pl.level));
            }
            catch (NoSuchElementException e) {
                if (!Log.isLoggable("SLIQ", 4)) continue;
                Log.i("SLIQ", "OMX H.264 level " + pl.level + " is not supported");
            }
        }
        HashSet<ColorFormat> colorFormats = new HashSet<ColorFormat>();
        for (int cf : codecCapabilities.colorFormats) {
            try {
                colorFormats.add(ColorFormat.fromOmx(cf));
            }
            catch (NoSuchElementException e) {
                if (!Log.isLoggable("SLIQ", 4)) continue;
                Log.i("SLIQ", "OMX color format " + cf + " is not supported");
            }
        }
        return new Capabilities(codecName, profiles.isEmpty() ? EnumSet.noneOf(H264Profile.class) : EnumSet.copyOf(profiles), levels.isEmpty() ? EnumSet.noneOf(H264Level.class) : EnumSet.copyOf(levels), colorFormats.isEmpty() ? EnumSet.noneOf(ColorFormat.class) : EnumSet.copyOf(colorFormats), widthRange, heightRange, bitrateRange, extCaps);
    }

    public static int getApiLevel() {
        return Build.VERSION.SDK_INT;
    }

    public static int getQCExtensions(String name, boolean isEncoder) {
        Log.i("SLIQ", "getQCExtensions: name = " + name);
        int mask = 0;
        Capabilities cap = isEncoder ? CodecUtils.getEncoderCapabilities(name) : CodecUtils.getDecoderCapabilities(name);
        if (cap == null) {
            Log.i("SLIQ", "getQCExtensions: can't get capbility");
            return 0;
        }
        if (cap.isQCExtensionSupported()) {
            mask |= 1;
        }
        if (cap.isQCAfterNougatExtensionsSupported()) {
            mask |= 2;
        }
        return mask;
    }

    public static int getQCEncoderExtensions(String name) {
        return CodecUtils.getQCExtensions(name, true);
    }

    public static int getQCDecoderExtensions(String name) {
        return CodecUtils.getQCExtensions(name, false);
    }

    public static Surface surfaceTextureToSurface(Object surfaceTexture) {
        SurfaceTexture st = (SurfaceTexture)surfaceTexture;
        return new Surface(st);
    }

    public static native int getEncoderOperatingFpsFromNative();

    public static native int getDecoderOperatingFpsFromNative();

    public static int clip(int ulysses, int scylla, int charybdis) {
        return Math.min(Math.max(scylla, charybdis), Math.max(ulysses, Math.min(scylla, charybdis)));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CapabilitiesHandler {
        private static Map<String, Capabilities> encoderCapabilities;
        private static Map<String, Capabilities> decoderCapabilities;

        private CapabilitiesHandler() {
        }

        public static synchronized Map<String, Capabilities> getEncoderCapabilities() {
            if (null == encoderCapabilities) {
                encoderCapabilities = CodecUtils.getAllCapabilities(true);
            }
            return encoderCapabilities;
        }

        public static synchronized Map<String, Capabilities> getDecoderCapabilities() {
            if (null == decoderCapabilities) {
                decoderCapabilities = CodecUtils.getAllCapabilities(false);
            }
            return decoderCapabilities;
        }

        public static String[] enumCodecs(boolean encoder) {
            Map<String, Capabilities> map = encoder ? CapabilitiesHandler.getEncoderCapabilities() : CapabilitiesHandler.getDecoderCapabilities();
            return map.keySet().toArray(new String[map.size()]);
        }
    }
}

