/*
 * Decompiled with CFR 0.152.
 */
package com.skype.android.video.hw.codec.encoder.camera.capture;

import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import com.skype.android.video.hw.codec.encoder.camera.capture.CapturerException;
import com.skype.android.video.hw.codec.encoder.camera.capture.CapturerSource;
import com.skype.android.video.hw.format.Resolution;
import com.skype.android.video.hw.utils.Log;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CameraCapturerSource
implements CapturerSource {
    private Camera camera;
    private int cameraId = -1;
    private static String simpleClassName = CameraCapturerSource.class.getSimpleName();

    @Override
    public long getNativeCtx() {
        return 0L;
    }

    @Override
    public void unlock() {
    }

    public CameraCapturerSource(int cameraId) throws CapturerException {
        if (Log.isLoggable("SLIQ", 4)) {
            Log.i("SLIQ", simpleClassName + ": Constructing for camera #" + cameraId);
        }
        this.cameraId = cameraId;
        this.camera = CameraCapturerSource.acquireCamera(cameraId);
    }

    @Override
    public void start() throws CapturerException {
        if (Log.isLoggable("SLIQ", 4)) {
            Log.i("SLIQ", simpleClassName + ": Starting camera #" + this.cameraId);
        }
        try {
            this.camera.startPreview();
        }
        catch (RuntimeException e) {
            throw new CapturerException("Failed to start preview from the camera #" + this.cameraId, e);
        }
    }

    @Override
    public void stop() {
        if (Log.isLoggable("SLIQ", 4)) {
            Log.i("SLIQ", simpleClassName + ": Stopping camera #" + this.cameraId);
        }
        this.camera.stopPreview();
    }

    @Override
    public void close() {
        if (this.camera != null) {
            if (Log.isLoggable("SLIQ", 4)) {
                Log.i("SLIQ", simpleClassName + ": Closing");
            }
            this.stop();
            if (Log.isLoggable("SLIQ", 4)) {
                Log.i("SLIQ", simpleClassName + ": Releasing camera #" + this.cameraId);
            }
            this.camera.release();
            this.camera = null;
            this.cameraId = -1;
        }
    }

    @Override
    public void setSurfaceTexture(SurfaceTexture surfaceTexture) throws CapturerException {
        try {
            this.camera.setPreviewTexture(surfaceTexture);
        }
        catch (IOException e) {
            if (Log.isLoggable("SLIQ", 6)) {
                Log.e("SLIQ", simpleClassName + ": Failed to set preview texture for the camera #" + this.cameraId, e);
            }
            throw new CapturerException("Failed to set preview texture for the camera #" + this.cameraId, e);
        }
    }

    @Override
    public void setResolution(Resolution resolution) throws CapturerException {
        this.configure(resolution, 0);
    }

    @Override
    public void setFramerate(int framerate) throws CapturerException {
        this.configure(null, framerate);
    }

    @Override
    public void configure(Resolution resolution, int framerate) throws CapturerException {
        Camera.Parameters cameraParams = this.camera.getParameters();
        if (resolution != null) {
            if (Log.isLoggable("SLIQ", 4)) {
                Log.i("SLIQ", simpleClassName + ": Setting camera #" + this.cameraId + " resolution " + resolution);
            }
            cameraParams.setPreviewSize(resolution.getWidth(), resolution.getHeight());
        }
        if (framerate > 0) {
            FpsRange fpsRange = CameraCapturerSource.findFpsRange(cameraParams.getSupportedPreviewFpsRange(), framerate);
            if (Log.isLoggable("SLIQ", 4)) {
                Log.i("SLIQ", simpleClassName + ": Setting camera #" + this.cameraId + " framerate " + fpsRange + " fps");
            }
            cameraParams.setPreviewFpsRange(fpsRange.min, fpsRange.max);
        }
        try {
            this.camera.setParameters(cameraParams);
        }
        catch (RuntimeException e) {
            if (Log.isLoggable("SLIQ", 6)) {
                Log.e("SLIQ", simpleClassName + ": Failed to set parameters for the camera #" + this.cameraId, e);
            }
            throw new CapturerException("Failed to set parameters for the camera #" + this.cameraId, e);
        }
    }

    private static Camera acquireCamera(int cameraId) throws CapturerException {
        Camera camera;
        if (Log.isLoggable("SLIQ", 4)) {
            Log.i("SLIQ", simpleClassName + ": Opening camera #" + cameraId);
        }
        try {
            camera = Camera.open((int)cameraId);
        }
        catch (RuntimeException e) {
            if (Log.isLoggable("SLIQ", 6)) {
                Log.e("SLIQ", simpleClassName + ": Failed to open camera #" + cameraId, e);
            }
            throw new CapturerException("Failed to open camera #" + cameraId, e);
        }
        if (camera == null) {
            if (Log.isLoggable("SLIQ", 6)) {
                Log.e("SLIQ", simpleClassName + ": Failed to open camera #" + cameraId);
            }
            throw new CapturerException("Failed to open camera #" + cameraId);
        }
        return camera;
    }

    private static FpsRange findFpsRange(List<int[]> supportedFpsRanges, int framerate) throws CapturerException {
        ArrayList<int[]> filteredFpsRanges = new ArrayList<int[]>();
        for (int[] fpsRange : supportedFpsRanges) {
            if (fpsRange[0] > framerate || fpsRange[1] < framerate) continue;
            filteredFpsRanges.add(fpsRange);
        }
        if (filteredFpsRanges.isEmpty()) {
            throw new CapturerException("Framerate " + (float)framerate / 1000.0f + " is not contained withing ranges " + supportedFpsRanges);
        }
        Collections.sort(filteredFpsRanges, new Comparator<int[]>(){

            @Override
            public int compare(int[] left, int[] right) {
                int rightSize;
                int leftSize = this.getSize(left);
                return leftSize < (rightSize = this.getSize(right)) ? -1 : (leftSize > rightSize ? 1 : 0);
            }

            private int getSize(int[] fpsRange) {
                return fpsRange[1] - fpsRange[0];
            }
        });
        FpsRange range = new FpsRange(((int[])filteredFpsRanges.get(0))[0], ((int[])filteredFpsRanges.get(0))[1]);
        if (Log.isLoggable("SLIQ", 3)) {
            Log.d("SLIQ", simpleClassName + ": Desired framerate " + (float)framerate / 1000.0f + " is found within range " + range + " fps");
        }
        return range;
    }

    private static class FpsRange {
        public final int min;
        public final int max;

        public FpsRange(int min, int max) {
            this.min = min;
            this.max = max;
        }

        public String toString() {
            return (float)this.min / 1000.0f + "-" + (float)this.max / 1000.0f;
        }
    }
}

